/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.aaa;

import java.security.MessageDigest;
import java.security.Principal;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class RealmBase
extends BaseInterceptor {
    int reqRolesNote = -1;
    int userNote = -1;
    int passwordNote = -1;
    protected static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    protected String digest = "No";

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String algorithm) {
        this.digest = algorithm;
    }

    public static final String digest(String credentials, String algorithm) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            md.update(credentials.getBytes());
            byte[] dig = md.digest();
            return HexUtils.convert((byte[])dig);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return credentials;
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2 && args[0].equalsIgnoreCase("-a")) {
            int i = 2;
            while (i < args.length) {
                System.out.print(args[i] + ":");
                System.out.println(RealmBase.digest(args[i], args[1]));
                ++i;
            }
        }
    }

    protected abstract String getCredentials(String var1);

    protected abstract String[] getUserRoles(String var1);

    protected abstract Principal getPrincipal(String var1);

    String digest(String credentials) {
        if (this.digest.equals("") || this.digest.equalsIgnoreCase("No")) {
            return credentials;
        }
        return RealmBase.digest(credentials, this.digest);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.reqRolesNote = cm.getNoteId(2, "required.roles");
        this.userNote = cm.getNoteId(2, "credentials.user");
        this.passwordNote = cm.getNoteId(2, "credentials.password");
    }

    public int authenticate(Request req, Response response) {
        String user = (String)req.getNote(this.userNote);
        String password = (String)req.getNote(this.passwordNote);
        if (user == null) {
            return -1;
        }
        if (this.checkPassword(user, password)) {
            Context ctx;
            if (this.debug > 0) {
                this.log("Auth ok, user=" + user);
            }
            if ((ctx = req.getContext()) != null) {
                req.setAuthType(ctx.getAuthMethod());
            }
            if (user != null) {
                req.setRemoteUser(user);
                req.setUserPrincipal(this.getPrincipal(user));
                String[] userRoles = this.getUserRoles(user);
                req.setUserRoles(userRoles);
                return 0;
            }
        }
        return -1;
    }

    private boolean checkPassword(String username, String credentials) {
        if (this.digest(credentials).equals(this.getCredentials(username))) {
            if (this.debug >= 2) {
                this.log(sm.getString("jdbcRealm.authenticateSuccess", (Object)username));
            }
            return true;
        }
        if (this.debug >= 2) {
            this.log(sm.getString("jdbcRealm.authenticateFailure", (Object)username));
        }
        return false;
    }
}

