/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.aaa;

import java.io.File;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.aaa.RealmBase;
import org.apache.tomcat.util.aaa.SimplePrincipal;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.AttributeList;

public class SimpleRealm
extends RealmBase {
    MemoryRealm memoryRealm;
    String filename = "/conf/users/tomcat-users.xml";

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String newFilename) {
        this.filename = newFilename;
    }

    public void contextInit(Context ctx) throws TomcatException {
        ContextManager cm = ctx.getContextManager();
        if (this.memoryRealm == null) {
            this.memoryRealm = new MemoryRealm(this.filename, cm.getHome());
            try {
                this.memoryRealm.readMemoryRealm();
            }
            catch (Exception ex) {
                this.log("Error loading realm file " + cm.getHome() + "/" + this.filename, ex);
                this.memoryRealm = null;
            }
        }
    }

    protected Principal getPrincipal(String username) {
        return this.memoryRealm.getPrincipal(username);
    }

    protected String getCredentials(String username) {
        SimpleRealmPrincipal sp = this.memoryRealm.getPrincipal(username);
        if (sp != null) {
            return sp.getCredentials();
        }
        return null;
    }

    protected String[] getUserRoles(String username) {
        SimpleRealmPrincipal sp = this.memoryRealm.getPrincipal(username);
        if (sp != null) {
            return sp.getUserRoles();
        }
        return null;
    }

    public static class SimpleRealmPrincipal
    extends SimplePrincipal {
        private String pass;
        private Vector roles = new Vector();

        SimpleRealmPrincipal(String name, String pass) {
            super(name);
            this.pass = pass;
        }

        private void addRole(String role) {
            this.roles.addElement(role);
        }

        String getCredentials() {
            return this.pass;
        }

        void addRoles(String groups) {
            int comma;
            groups = groups + ",";
            while ((comma = groups.indexOf(",")) >= 0) {
                this.addRole(groups.substring(0, comma).trim());
                groups = groups.substring(comma + 1);
            }
        }

        String[] getUserRoles() {
            String[] rolesA = new String[this.roles.size()];
            int i = 0;
            while (i < this.roles.size()) {
                rolesA[i] = (String)this.roles.elementAt(i);
                ++i;
            }
            return rolesA;
        }
    }

    class MemoryRealm {
        Hashtable principals = new Hashtable();
        String filename;
        String home;

        MemoryRealm(String fn, String home) {
            this.home = home;
            this.filename = fn;
        }

        public SimpleRealmPrincipal getPrincipal(String user) {
            return (SimpleRealmPrincipal)((Object)this.principals.get(user));
        }

        public void addPrincipal(String name, Principal p) {
            this.principals.put(name, p);
        }

        public void addUser(String name, String pass, String groups) {
            if (SimpleRealm.this.getDebug() > 0) {
                SimpleRealm.this.log("Add user " + name + " " + pass + " " + groups);
            }
            SimpleRealmPrincipal sp = new SimpleRealmPrincipal(name, pass);
            sp.addRoles(groups);
            this.principals.put(name, sp);
        }

        void readMemoryRealm() throws Exception {
            File f = this.filename != null ? new File(this.home + File.separator + this.filename) : new File(this.home + "/conf/users/tomcat-users.xml");
            if (!f.exists()) {
                SimpleRealm.this.log("File not found  " + f);
                return;
            }
            XmlMapper xh = new XmlMapper();
            if (SimpleRealm.this.getDebug() > 5) {
                xh.setDebug(2);
            }
            xh.addRule("tomcat-users/user", new XmlAction(this){
                private final /* synthetic */ MemoryRealm this$1;
                {
                    this.this$1 = this$1;
                }

                public void start(SaxContext sctx) throws Exception {
                    int top = sctx.getTagCount() - 1;
                    MemoryRealm mr = (MemoryRealm)sctx.getRoot();
                    AttributeList attributes = sctx.getAttributeList(top);
                    String user = attributes.getValue("name");
                    String pass = attributes.getValue("password");
                    String group = attributes.getValue("roles");
                    mr.addUser(user, pass, group);
                }
            });
            xh.readXml(f, (Object)this);
        }
    }
}

