/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.config.ServerXmlReader;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.AttributeList;

public class ContextXmlReader
extends BaseInterceptor {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    String configFile = null;
    static final String DEFAULT_CONFIG = "conf/server.xml";

    public void setConfig(String s) {
        this.configFile = s;
    }

    public void setHome(String h) {
        ((Hashtable)System.getProperties()).put("tomcat.home", h);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        if (this.configFile == null) {
            this.configFile = (String)cm.getNote("configFile");
        }
        XmlMapper xh = new XmlMapper();
        xh.setDebug(this.debug);
        this.addTagRules(cm, xh);
        ContextXmlReader.setContextRules(xh);
        ContextXmlReader.setPropertiesRules(cm, xh);
        ContextXmlReader.setBackward(xh);
        File f = null;
        if (this.configFile == null) {
            this.configFile = DEFAULT_CONFIG;
        }
        if (File.separatorChar != '/') {
            this.configFile = this.configFile.replace('/', File.separatorChar);
        }
        if (!(f = new File(this.configFile)).isAbsolute()) {
            f = new File(cm.getHome(), this.configFile);
        }
        if (f.exists()) {
            ServerXmlReader.loadConfigFile(xh, f, cm);
        }
        Vector v = ServerXmlReader.getUserConfigFiles(f);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            f = (File)e.nextElement();
            if (f.exists()) {
                String s = f.getAbsolutePath();
                if (s.startsWith(cm.getHome())) {
                    s = "$TOMCAT_HOME" + s.substring(cm.getHome().length());
                }
                this.log("Context config=" + s);
            }
            ServerXmlReader.loadConfigFile(xh, f, cm);
        }
    }

    public static void setPropertiesRules(ContextManager cm, XmlMapper xh) throws TomcatException {
        ContextPropertySource propS = new ContextPropertySource(cm);
        xh.setPropertySource((Object)propS);
        xh.addRule("Context/Property", new XmlAction(){

            public void start(SaxContext ctx) throws Exception {
                AttributeList attributes = ctx.getCurrentAttributes();
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (name == null || value == null) {
                    return;
                }
                XmlMapper xm = ctx.getMapper();
                Context context = (Context)ctx.currentObject();
                value = xm.replaceProperties(value);
                if (context.getDebug() > 0) {
                    context.log("Setting " + name + "=" + value);
                }
                context.setProperty(name, value);
            }
        });
    }

    public static void setContextRules(XmlMapper xh) {
        xh.addRule("Context", xh.objectCreate("org.apache.tomcat.core.Context"));
        xh.addRule("Context", xh.setProperties());
        xh.addRule("Context", xh.setParent("setContextManager"));
        xh.addRule("Host", xh.setVar("current_host", "name"));
        xh.addRule("Host", xh.setVar("current_address", "address"));
        xh.addRule("Host", xh.setVar("host_aliases", ""));
        xh.addRule("Host", xh.setProperties());
        xh.addRule("Alias", new XmlAction(){

            public void start(SaxContext xctx) throws Exception {
                String alias;
                Vector<String> aliases = (Vector<String>)xctx.getVariable("host_aliases");
                if (aliases == null) {
                    aliases = new Vector<String>();
                    xctx.setVariable("host_aliases", aliases);
                }
                if ((alias = xctx.getCurrentAttributes().getValue("name")) != null) {
                    aliases.addElement(alias);
                }
            }
        });
        xh.addRule("Context", new XmlAction(){

            public void start(SaxContext xctx) throws Exception {
                Context tcCtx = (Context)xctx.currentObject();
                XmlMapper xm = xctx.getMapper();
                ContextPropertySource propS = (ContextPropertySource)xm.getPropertySource();
                if (propS != null) {
                    propS.setContext(tcCtx);
                }
            }
        });
        xh.addRule("Context", new XmlAction(){

            public void end(SaxContext xctx) throws Exception {
                Context tcCtx = (Context)xctx.currentObject();
                XmlMapper xm = xctx.getMapper();
                ContextPropertySource propS = (ContextPropertySource)xm.getPropertySource();
                if (propS != null) {
                    propS.setContext(null);
                }
                String host = (String)xctx.getVariable("current_host");
                String address = (String)xctx.getVariable("current_address");
                Vector aliases = (Vector)xctx.getVariable("host_aliases");
                if (host != null && !"DEFAULT".equals(host)) {
                    tcCtx.setHost(host);
                    tcCtx.setHostAddress(address);
                    if (aliases != null) {
                        Enumeration alE = aliases.elements();
                        while (alE.hasMoreElements()) {
                            String alias = (String)alE.nextElement();
                            tcCtx.addHostAlias(alias);
                            if (tcCtx.getDebug() <= 0) continue;
                            tcCtx.log("Alias " + host + " " + alias);
                        }
                    }
                }
            }
        });
        xh.addRule("Context", xh.addChild("addContext", "org.apache.tomcat.core.Context"));
    }

    private static void setBackward(XmlMapper xh) {
        xh.addRule("Context/Interceptor", xh.objectCreate(null, "className"));
        xh.addRule("Context/Interceptor", xh.setProperties());
        xh.addRule("Context/Interceptor", xh.setParent("setContext"));
        xh.addRule("Context/Interceptor", xh.addChild("addInterceptor", "org.apache.tomcat.core.BaseInterceptor"));
        xh.addRule("Context/RequestInterceptor", xh.objectCreate(null, "className"));
        xh.addRule("Context/RequestInterceptor", xh.setProperties());
        xh.addRule("Context/RequestInterceptor", xh.setParent("setContext"));
        xh.addRule("Context/RequestInterceptor", xh.addChild("addInterceptor", "org.apache.tomcat.core.BaseInterceptor"));
        xh.addRule("Context/Logger", xh.objectCreate("org.apache.tomcat.util.log.QueueLogger"));
        xh.addRule("Context/Logger", xh.setProperties());
        xh.addRule("Context/Logger", xh.addChild("setLogger", "org.apache.tomcat.util.log.Logger"));
        xh.addRule("Context/ServletLogger", xh.objectCreate("org.apache.tomcat.util.log.QueueLogger"));
        xh.addRule("Context/ServletLogger", xh.setProperties());
        xh.addRule("Context/ServletLogger", xh.addChild("setServletLogger", "org.apache.tomcat.util.log.Logger"));
    }

    public void addTagRules(ContextManager cm, XmlMapper xh) throws TomcatException {
        Hashtable modules = (Hashtable)cm.getNote("modules");
        if (modules == null) {
            return;
        }
        Enumeration keys = modules.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String classN = (String)modules.get(name);
            String tag = "Context/" + name;
            xh.addRule(tag, xh.objectCreate(classN, null));
            xh.addRule(tag, xh.setProperties());
            xh.addRule(tag, xh.addChild("addInterceptor", "org.apache.tomcat.core.BaseInterceptor"));
        }
    }

    static class ContextPropertySource
    implements IntrospectionUtils.PropertySource {
        ContextManager cm;
        Context ctx = null;

        ContextPropertySource(ContextManager cm) {
            this.cm = cm;
        }

        public void setContext(Context ctx) {
            this.ctx = ctx;
        }

        public String getProperty(String key) {
            String s = null;
            if (this.ctx != null) {
                s = this.ctx.getProperty(key);
            }
            if (s == null) {
                s = this.cm.getProperty(key);
            }
            if (s == null) {
                s = System.getProperty(key);
            }
            return s;
        }
    }
}

