/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.config.BaseJkConfig;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.log.Log;

public class IISConfig
extends BaseJkConfig {
    public static final String WORKERS_CONFIG = "conf/jk/workers.properties";
    public static final String URI_WORKERS_MAP_CONFIG = "conf/auto/uriworkermap.properties";
    public static final String ISAPI_LOG_LOCATION = "logs/iis_redirect.log";
    public static final String ISAPI_REG_FILE = "conf/auto/iis_redirect.reg";
    public static final String ISAPI_PROP_FILE = "conf/auto/isapi_redirect.properties";
    public static final String ISAPI_REDIRECTOR = "isapi_redirect.dll";
    private File regConfig = null;
    private File propConfig = null;
    private File uriConfig = null;
    private String isapiRedirector = null;

    private void updatePropFile() {
        int idx;
        this.propConfig = null;
        if (this.isapiRedirector != null && (idx = this.isapiRedirector.lastIndexOf(46)) > 0) {
            String dir = this.regConfig != null ? this.regConfig.toString().replace(File.separatorChar, '/') : ISAPI_REG_FILE;
            int idx2 = dir.lastIndexOf(47);
            dir = idx2 > 0 ? dir.substring(0, idx2 + 1) : "";
            this.propConfig = new File(dir + this.isapiRedirector.substring(0, idx) + ".properties");
        }
    }

    public void setRegConfig(String path) {
        this.regConfig = path == null ? null : new File(path);
        this.updatePropFile();
    }

    public void setUriConfig(String path) {
        this.uriConfig = path == null ? null : new File(path);
    }

    public void setIsapiRedirector(String s) {
        this.isapiRedirector = s;
        this.updatePropFile();
    }

    protected void initProperties(ContextManager cm) {
        super.initProperties(cm);
        this.regConfig = FileUtil.getConfigFile((File)this.regConfig, (File)this.configHome, (String)ISAPI_REG_FILE);
        this.propConfig = FileUtil.getConfigFile((File)this.propConfig, (File)this.configHome, (String)ISAPI_PROP_FILE);
        this.workersConfig = FileUtil.getConfigFile((File)this.workersConfig, (File)this.configHome, (String)WORKERS_CONFIG);
        this.uriConfig = FileUtil.getConfigFile((File)this.uriConfig, (File)this.configHome, (String)URI_WORKERS_MAP_CONFIG);
        this.jkLog = FileUtil.getConfigFile((File)this.jkLog, (File)this.configHome, (String)ISAPI_LOG_LOCATION);
    }

    public void execute(ContextManager cm) throws TomcatException {
        try {
            this.initProperties(cm);
            this.initWorker(cm);
            PrintWriter regfile = new PrintWriter(new FileWriter(this.regConfig));
            PrintWriter propfile = new PrintWriter(new FileWriter(this.propConfig));
            PrintWriter uri_worker = new PrintWriter(new FileWriter(this.uriConfig));
            this.log("Generating IIS registry file = " + this.regConfig);
            this.log("Generating IIS properties file = " + this.propConfig);
            this.log("Generating IIS URI worker map file = " + this.uriConfig);
            this.generateRegistrySettings(regfile);
            this.generatePropertySettings(propfile);
            this.generateUriWorkerHeader(uri_worker);
            Enumeration enumeration = cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Context context = (Context)enumeration.nextElement();
                String vhost = context.getHost();
                if (vhost != null) continue;
                if (this.forwardAll) {
                    this.generateStupidMappings(context, uri_worker);
                    continue;
                }
                this.generateContextMappings(context, uri_worker);
            }
            regfile.close();
            propfile.close();
            uri_worker.close();
        }
        catch (Exception ex) {
            Log loghelper = Log.getLog((String)"tc_log", (Object)((Object)this));
            loghelper.log("Error generating automatic IIS configuration", (Throwable)ex);
        }
    }

    private void generateRegistrySettings(PrintWriter regfile) {
        regfile.println("REGEDIT4");
        regfile.println();
        regfile.println("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Apache Software Foundation\\Jakarta Isapi Redirector\\1.0]");
        regfile.println("\"extension_uri\"=\"/jakarta/" + (this.isapiRedirector != null ? this.isapiRedirector : ISAPI_REDIRECTOR) + "\"");
        regfile.println("\"log_file\"=\"" + this.dubleSlash(this.jkLog.toString()) + "\"");
        regfile.println("\"log_level\"=\"" + this.jkDebug + "\"");
        regfile.println("\"worker_file\"=\"" + this.dubleSlash(this.workersConfig.toString()) + "\"");
        regfile.println("\"worker_mount_file\"=\"" + this.dubleSlash(this.uriConfig.toString()) + "\"");
        regfile.println("\"uri_select\"=\"parsed\"");
    }

    private void generatePropertySettings(PrintWriter propfile) {
        propfile.println("extension_uri=/jakarta/" + (this.isapiRedirector != null ? this.isapiRedirector : ISAPI_REDIRECTOR));
        propfile.println("log_file=" + this.jkLog.toString());
        propfile.println("log_level=" + this.jkDebug);
        propfile.println("worker_file=" + this.workersConfig.toString());
        propfile.println("worker_mount_file=" + this.uriConfig.toString());
        propfile.println("uri_select=parsed");
    }

    private void generateUriWorkerHeader(PrintWriter uri_worker) {
        uri_worker.println("###################################################################");
        uri_worker.println("# Auto generated configuration. Dated: " + new Date());
        uri_worker.println("###################################################################");
        uri_worker.println();
        uri_worker.println("#");
        uri_worker.println("# Default worker to be used through our mappings");
        uri_worker.println("#");
        uri_worker.println("default.worker=" + this.jkWorker);
        uri_worker.println();
    }

    private void generateStupidMappings(Context context, PrintWriter uri_worker) {
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        uri_worker.println(nPath + "=$(default.worker)");
        if ("".equals(ctxPath)) {
            uri_worker.println(nPath + "*=$(default.worker)");
            uri_worker.println("# Note: To correctly serve the Tomcat's root context, IIS's Home Directory must");
            uri_worker.println("# must be set to: \"" + this.getAbsoluteDocBase(context) + "\"");
        } else {
            uri_worker.println(nPath + "/*=$(default.worker)");
        }
    }

    private void generateContextMappings(Context context, PrintWriter uri_worker) {
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        uri_worker.println();
        uri_worker.println("#########################################################");
        uri_worker.println("# Auto configuration for the " + nPath + " context.");
        uri_worker.println("#########################################################");
        uri_worker.println();
        this.addMapping(ctxPath + "/servlet/*", uri_worker);
        Enumeration servletMaps = context.getContainers();
        while (servletMaps.hasMoreElements()) {
            Container ct = (Container)servletMaps.nextElement();
            this.addMapping(context, ct, uri_worker);
        }
    }

    protected boolean addExtensionMapping(String ctxPath, String ext, PrintWriter uri_worker) {
        if (this.debug > 0) {
            this.log("Adding extension map for " + ctxPath + "/*." + ext);
        }
        uri_worker.println(ctxPath + "/*." + ext + "=$(default.worker)");
        return true;
    }

    protected boolean addMapping(String fullPath, PrintWriter uri_worker) {
        if (this.debug > 0) {
            this.log("Adding map for " + fullPath);
        }
        if (fullPath.endsWith("/*")) {
            uri_worker.println(fullPath.substring(0, fullPath.length() - 2) + "=$(default.worker)");
        }
        uri_worker.println(fullPath + "=$(default.worker)");
        return true;
    }

    private String dubleSlash(String in) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            if ('\\' == ch) {
                sb.append("\\\\");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }
}

