/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.net.URLEncoder;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.io.FileUtil;

public class WorkDirSetup
extends BaseInterceptor {
    public static final String DEFAULT_WORK_DIR = "work";
    boolean cleanWorkDir = false;
    String workdirBase = null;
    boolean useWebInf = false;
    boolean oldStyle = false;
    private int attributeInfo;
    public static final String ATTRIB_WORKDIR = "javax.servlet.context.tempdir";

    public void setCleanWorkDir(boolean b) {
        this.cleanWorkDir = b;
    }

    public void setWorkDirBase(String s) {
        this.workdirBase = s;
    }

    public void setUseWebInf(boolean useWebInf) {
        this.useWebInf = useWebInf;
    }

    public void setOldStyle(boolean b) {
        this.oldStyle = b;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.attributeInfo = cm.getNoteId(2, "req.attribute");
    }

    public void addContext(ContextManager cm, Context ctx) {
        if (ctx.getWorkDir() == null) {
            this.initWorkDir(ctx);
        }
        if (this.cleanWorkDir) {
            FileUtil.clearDir((File)ctx.getWorkDir());
        }
        if (!ctx.getWorkDir().exists()) {
            this.log("Creating work dir " + ctx.getWorkDir());
            ctx.getWorkDir().mkdirs();
        }
    }

    public void contextShutdown(Context ctx) {
        if (this.cleanWorkDir) {
            FileUtil.clearDir((File)ctx.getWorkDir());
        }
    }

    public final Object getInfo(Context ctx, Request req, int info, String k) {
        if (req != null) {
            return null;
        }
        if (info == this.attributeInfo && k.equals(ATTRIB_WORKDIR)) {
            return ctx.getWorkDir();
        }
        return null;
    }

    private void initWorkDir(Context ctx) {
        if (this.useWebInf) {
            this.initWebInfWorkDir(ctx);
        } else {
            this.initStandaloneWorkDir(ctx);
        }
    }

    private void initWebInfWorkDir(Context ctx) {
        String absPath = ctx.getAbsolutePath();
        StringBuffer sb = new StringBuffer();
        sb.append(absPath).append(File.separator);
        sb.append("WEB-INF").append(File.separator);
        sb.append("TOMCAT_WORKDIR").append(File.separator);
        String path = ctx.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ("".equals(path)) {
            path = "ROOT";
        }
        sb.append(URLEncoder.encode(path).replace('%', '_'));
        File workDirF = new File(sb.toString());
        workDirF.mkdirs();
        ctx.setWorkDir(workDirF);
    }

    private void initStandaloneWorkDir(Context ctx) {
        ContextManager cm = ctx.getContextManager();
        String base = this.workdirBase;
        if (base == null) {
            base = cm.getWorkDir();
        }
        File workDirF = null;
        StringBuffer sb = new StringBuffer();
        sb.append(cm.getWorkDir());
        sb.append(File.separator);
        String host = ctx.getHost();
        if (host == null) {
            sb.append("DEFAULT");
        } else {
            sb.append(host.replace(':', '_'));
        }
        if (this.oldStyle) {
            sb.append(URLEncoder.encode(ctx.getPath()).replace('%', '_'));
            workDirF = new File(sb.toString());
        } else {
            File hostD = new File(sb.toString());
            hostD.mkdirs();
            String path = ctx.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ("".equals(path)) {
                path = "ROOT";
            }
            workDirF = new File(hostD, URLEncoder.encode(path).replace('%', '_'));
        }
        ctx.setWorkDir(workDirF);
    }
}

