/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.compat.Jdk11Compat;

public final class Jdk12Interceptor
extends BaseInterceptor {
    private ContextManager cm;
    private int debug = 0;
    static Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();

    public void preServletInit(Context ctx, Handler sw) throws TomcatException {
        this.fixJDKContextClassLoader(ctx);
    }

    public void preServletDestroy(Context ctx, Handler sw) throws TomcatException {
        this.fixJDKContextClassLoader(ctx);
    }

    public void postServletDestroy(Context ctx, Handler sw) throws TomcatException {
        jdk11Compat.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    public void postServletInit(Context ctx, Handler sw) throws TomcatException {
        jdk11Compat.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    public int preService(Request request, Response response) {
        if (request.getContext() == null) {
            return 0;
        }
        Request child = request.getChild();
        if (child != null) {
            request = child;
        }
        this.fixJDKContextClassLoader(request.getContext());
        return 0;
    }

    public int postService(Request request, Response response) {
        Request child = request.getChild();
        if (child == null) {
            return 0;
        }
        request = child.getParent();
        if (request != null) {
            this.fixJDKContextClassLoader(request.getContext());
        } else {
            jdk11Compat.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        }
        return 0;
    }

    private final void fixJDKContextClassLoader(Context ctx) {
        ClassLoader cl = ctx.getClassLoader();
        if (cl == null) {
            this.log("ERROR: Jdk12Interceptor: classloader==null");
            return;
        }
        if (cl == jdk11Compat.getContextClassLoader()) {
            return;
        }
        jdk11Compat.setContextClassLoader(cl);
    }
}

