/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.server.AJP12Request;
import org.apache.tomcat.modules.server.AJP12Response;
import org.apache.tomcat.modules.server.PoolTcpConnector;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.net.TcpConnectionHandler;

public class Ajp12Interceptor
extends PoolTcpConnector
implements TcpConnectionHandler {
    private boolean tomcatAuthentication = true;
    String secret;
    File ajpidFile = null;

    protected void localInit() throws Exception {
        this.ep.setConnectionHandler((TcpConnectionHandler)this);
    }

    public void setUseSecret(boolean b) {
        this.secret = Double.toString(Math.random());
    }

    public void setSecret(String s) {
        this.secret = s;
    }

    public void setAjpidFile(String path) {
        this.ajpidFile = path == null ? null : new File(path);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        String ajpid12 = cm.getProperty("ajpid12");
        if (ajpid12 != null) {
            if (this.ajpidFile != null) {
                this.log("Overriding ajpidFile with " + ajpid12);
            }
            this.ajpidFile = new File(ajpid12);
        }
    }

    public void engineState(ContextManager cm, int state) throws TomcatException {
        if (state != 3) {
            return;
        }
        Ajp12Interceptor tcpCon = this;
        int portInt = tcpCon.getPort();
        InetAddress address = tcpCon.getAddress();
        File sf = FileUtil.getConfigFile((File)this.ajpidFile, (File)new File(cm.getHome()), (String)"conf/ajp12.id");
        if (this.ajpidFile != null || this.debug > 0) {
            this.log("Using stop file: " + sf);
        }
        try {
            PrintWriter stopF = new PrintWriter(new FileWriter(sf));
            stopF.println(portInt);
            if (address == null) {
                stopF.println("");
            } else {
                stopF.println(address.getHostAddress());
            }
            if (this.secret != null) {
                stopF.println(this.secret);
            } else {
                stopF.println();
            }
            stopF.close();
        }
        catch (IOException ex) {
            this.log("Can't create stop file: " + sf, ex);
        }
    }

    public Object[] init() {
        Object[] thData = new Object[2];
        AJP12Request reqA = new AJP12Request();
        reqA.setSecret(this.secret);
        reqA.setTomcatAuthentication(this.isTomcatAuthentication());
        AJP12Response resA = new AJP12Response();
        this.cm.initRequest((Request)reqA, (Response)resA);
        thData[0] = reqA;
        thData[1] = resA;
        return thData;
    }

    public void setServer(Object cm) {
        this.cm = (ContextManager)cm;
    }

    public void processConnection(TcpConnection connection, Object[] thData) {
        try {
            if (connection == null) {
                return;
            }
            Socket socket = connection.getSocket();
            if (socket == null) {
                return;
            }
            socket.setSoLinger(true, 100);
            AJP12Request reqA = null;
            AJP12Response resA = null;
            if (thData != null) {
                reqA = (AJP12Request)((Object)thData[0]);
                resA = (AJP12Response)((Object)thData[1]);
                if (reqA != null) {
                    reqA.recycle();
                }
                if (resA != null) {
                    resA.recycle();
                }
            }
            if (reqA == null || resA == null) {
                reqA = new AJP12Request();
                reqA.setSecret(this.secret);
                reqA.setTomcatAuthentication(this.isTomcatAuthentication());
                resA = new AJP12Response();
                this.cm.initRequest((Request)reqA, (Response)resA);
            }
            reqA.setSocket(socket);
            resA.setSocket(socket);
            reqA.readNextRequest();
            if (reqA.internalAjp()) {
                return;
            }
            this.cm.service((Request)reqA, (Response)resA);
            socket.close();
        }
        catch (Exception e) {
            this.log("HANDLER THREAD PROBLEM", e);
        }
    }

    public boolean isTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean newTomcatAuthentication) {
        this.tomcatAuthentication = newTomcatAuthentication;
    }
}

