/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.session;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.buf.TimeStamp;
import org.apache.tomcat.util.threads.Expirer;

public final class SessionExpirer
extends BaseInterceptor {
    int manager_note;
    int checkInterval = 60;
    Expirer expirer = null;

    public void setCheckInterval(int secs) {
        this.checkInterval = secs;
    }

    public Expirer getExpirer() {
        return this.expirer;
    }

    public void engineStart(ContextManager cm) throws TomcatException {
        this.expirer = new Expirer();
        this.expirer.setCheckInterval(this.checkInterval);
        this.expirer.setExpireCallback((Expirer.ExpireCallback)new SessionExpireCallback(this, this.debug));
        this.expirer.start();
    }

    public void engineStop(ContextManager cm) throws TomcatException {
        this.expirer.stop();
    }

    public int sessionState(Request req, ServerSession session, int state) {
        TimeStamp ts = session.getTimeStamp();
        if (state == 0) {
            if (this.debug > 0) {
                this.log("Registering new session for expiry checks");
            }
            ts.setNew(true);
            ts.setValid(true);
            ts.setCreationTime(System.currentTimeMillis());
            Context ctx = session.getContext();
            ts.setMaxInactiveInterval((long)(ctx.getSessionTimeOut() * 60000));
            session.getTimeStamp().setParent((Object)session);
            this.expirer.addManagedObject(ts);
        } else if (state == 2) {
            if (this.debug > 0) {
                this.log("Removing expired session from expiry checks");
            }
            this.expirer.removeManagedObject(ts);
        }
        return state;
    }

    static class SessionExpireCallback
    implements Expirer.ExpireCallback {
        SessionExpirer se;
        int debug;

        SessionExpireCallback(SessionExpirer se, int debug) {
            this.se = se;
            this.debug = debug;
        }

        public void expired(TimeStamp o) {
            ServerSession sses = (ServerSession)o.getParent();
            if (this.debug > 0) {
                this.se.log("Session expired " + sses);
            }
            sses.setState(2);
            if (this.debug > 0) {
                this.se.log("Recycling " + sses);
            }
            sses.recycle();
        }
    }
}

