/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsql.Cache;
import org.hsql.Channel;
import org.hsql.Database;
import org.hsql.Index;
import org.hsql.Node;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.StringConverter;
import org.hsql.Table;
import org.hsql.Trace;

class Log
implements Runnable {
    private static int COPY_BLOCK_SIZE = 65536;
    private FileInputStream fProperties;
    private Properties pProperties;
    private String sName;
    private Database dDatabase;
    private Channel cSystem;
    private Writer wScript;
    private String sFileProperties;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private boolean bRestoring;
    private boolean bReadOnly;
    private int iLogSize = 200;
    private int iLogCount;
    private Thread tRunner;
    private volatile boolean bNeedFlush;
    private volatile boolean bWriteDelay;
    Cache cCache;

    public void run() {
        while (this.tRunner != null) {
            try {
                Thread.sleep(1000L);
                if (!this.bNeedFlush) continue;
                this.wScript.flush();
                this.bNeedFlush = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setWriteDelay(boolean bl) {
        this.bWriteDelay = bl;
    }

    boolean open() throws SQLException {
        if (!new File(this.sFileProperties).exists()) {
            this.create();
            this.open();
            return true;
        }
        this.loadProperties();
        this.sFileScript = this.pProperties.getProperty("script", this.sName + ".script");
        this.sFileCache = this.pProperties.getProperty("data", this.sName + ".data");
        this.sFileBackup = this.pProperties.getProperty("backup", this.sName + ".backup");
        String string = this.pProperties.getProperty("version", "1.0");
        boolean bl = string.equals("1.4");
        Trace.check(bl, 29);
        if (this.pProperties.getProperty("readonly", "false").equals("true")) {
            this.bReadOnly = true;
            this.dDatabase.setReadOnly();
            this.cCache = new Cache(this.sFileCache);
            this.cCache.open(true);
            this.runScript();
            return false;
        }
        boolean bl2 = false;
        String string2 = this.pProperties.getProperty("modified", "no");
        if (string2.equals("yes-new-files")) {
            this.renameNewToCurrent(this.sFileScript);
            this.renameNewToCurrent(this.sFileBackup);
        } else if (string2.equals("yes")) {
            if (this.isAlreadyOpen()) {
                throw Trace.error(0);
            }
            this.restoreBackup();
            bl2 = true;
        }
        this.pProperties.put("modified", "yes");
        this.saveProperties();
        this.cCache = new Cache(this.sFileCache);
        this.cCache.open(false);
        this.runScript();
        if (bl2) {
            this.close(false);
            this.pProperties.put("modified", "yes");
            this.saveProperties();
            this.cCache.open(false);
        }
        this.openScript();
        return false;
    }

    void stop() {
        this.tRunner = null;
    }

    void close(boolean bl) throws SQLException {
        if (this.bReadOnly) {
            return;
        }
        this.closeScript();
        this.writeScript(bl);
        this.cCache.flush();
        this.backup();
        this.pProperties.put("modified", "yes-new-files");
        this.saveProperties();
        this.renameNewToCurrent(this.sFileScript);
        this.renameNewToCurrent(this.sFileBackup);
        this.pProperties.put("modified", "no");
        this.saveProperties();
        this.closeProperties();
        if (bl) {
            new File(this.sFileCache).delete();
            new File(this.sFileBackup).delete();
            Database database = new Database(this.sName);
            database.getLog().close(false);
        }
    }

    void checkpoint() throws SQLException {
        this.close(false);
        this.pProperties.put("modified", "yes");
        this.saveProperties();
        this.cCache.open(false);
        this.openScript();
    }

    void setLogSize(int n) {
        this.iLogSize = n;
    }

    void write(String string) throws SQLException {
        if (this.bRestoring || string == null || string.equals("")) {
            return;
        }
        try {
            Log.writeLine(this.wScript, string);
            if (this.bWriteDelay) {
                this.bNeedFlush = true;
            } else {
                this.wScript.flush();
            }
        }
        catch (IOException iOException) {
            Trace.error(28, this.sFileScript);
        }
        if (this.iLogSize > 0 && this.iLogCount++ > 100) {
            this.iLogCount = 0;
            if (new File(this.sFileScript).length() > (long)(this.iLogSize * 1024 * 1024)) {
                this.checkpoint();
            }
        }
    }

    void shutdown() throws SQLException {
        this.tRunner = null;
        this.cCache.shutdown();
        this.closeScript();
        this.closeProperties();
    }

    static void scriptToFile(Database database, String string, boolean bl, Channel channel) throws SQLException {
        if (new File(string).exists()) {
            throw Trace.error(28, string);
        }
        try {
            long l = System.currentTimeMillis();
            Result result = bl ? database.getScript(false, false, false, channel) : database.getScript(false, false, true, channel);
            Record record = result.rRoot;
            FileWriter fileWriter = new FileWriter(string);
            while (record != null) {
                Log.writeLine(fileWriter, (String)record.data[0]);
                record = record.next;
            }
            Vector vector = database.getTables();
            int n = 0;
            while (n < vector.size()) {
                Table table = (Table)vector.elementAt(n);
                if (bl || !table.isCached()) {
                    Index index = table.getPrimaryIndex();
                    Node node = index.first();
                    while (node != null) {
                        Log.writeLine(fileWriter, table.getInsertStatement(node.getData()));
                        node = index.next(node);
                    }
                }
                ++n;
            }
            fileWriter.close();
            l = System.currentTimeMillis() - l;
        }
        catch (IOException iOException) {
            Trace.error(28, string + " " + iOException);
        }
    }

    private void renameNewToCurrent(String string) {
        if (new File(string + ".new").exists()) {
            new File(string).delete();
            new File(string + ".new").renameTo(new File(string));
        }
    }

    private void closeProperties() throws SQLException {
        try {
            if (this.fProperties != null) {
                this.fProperties.close();
                this.fProperties = null;
            }
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileProperties + " " + exception);
        }
    }

    private void create() throws SQLException {
        this.pProperties.put("modified", "no");
        this.pProperties.put("version", "1.4");
        this.saveProperties();
    }

    private boolean isAlreadyOpen() throws SQLException {
        this.closeProperties();
        if (!new File(this.sFileProperties).delete()) {
            return true;
        }
        this.saveProperties();
        return false;
    }

    private void loadProperties() throws SQLException {
        File file = new File(this.sFileProperties);
        this.closeProperties();
        try {
            this.fProperties = new FileInputStream(file);
            this.pProperties.load(this.fProperties);
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileProperties);
        }
    }

    private void saveProperties() throws SQLException {
        File file = new File(this.sFileProperties);
        this.closeProperties();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.pProperties.store(fileOutputStream, "Hypersonic SQL database");
            fileOutputStream.close();
            this.loadProperties();
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileProperties);
        }
    }

    private void backup() throws SQLException {
        if (!new File(this.sFileCache).exists()) {
            return;
        }
        try {
            int n;
            long l = System.currentTimeMillis();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)new FileOutputStream(this.sFileBackup + ".new"), new Deflater(1), COPY_BLOCK_SIZE);
            byte[] byArray = new byte[COPY_BLOCK_SIZE];
            FileInputStream fileInputStream = new FileInputStream(this.sFileCache);
            while ((n = fileInputStream.read(byArray, 0, COPY_BLOCK_SIZE)) != -1) {
                deflaterOutputStream.write(byArray, 0, n);
            }
            deflaterOutputStream.close();
            fileInputStream.close();
            l = System.currentTimeMillis() - l;
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileBackup);
        }
    }

    private void restoreBackup() throws SQLException {
        if (!new File(this.sFileBackup).exists()) {
            new File(this.sFileCache).delete();
            return;
        }
        try {
            int n;
            long l = System.currentTimeMillis();
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new FileInputStream(this.sFileBackup), new Inflater());
            FileOutputStream fileOutputStream = new FileOutputStream(this.sFileCache);
            byte[] byArray = new byte[COPY_BLOCK_SIZE];
            while ((n = inflaterInputStream.read(byArray, 0, COPY_BLOCK_SIZE)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            inflaterInputStream.close();
            l = System.currentTimeMillis() - l;
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileBackup);
        }
    }

    private void openScript() throws SQLException {
        try {
            this.wScript = new BufferedWriter(new FileWriter(this.sFileScript, true), 4096);
        }
        catch (Exception exception) {
            Trace.error(28, this.sFileScript);
        }
    }

    private void closeScript() throws SQLException {
        try {
            if (this.wScript != null) {
                this.wScript.close();
                this.wScript = null;
            }
        }
        catch (Exception exception) {
            Trace.error(28, this.sFileScript);
        }
    }

    private void runScript() throws SQLException {
        if (new File(this.sFileScript).exists()) {
            this.bRestoring = true;
            this.dDatabase.setReferencialIntegrity(false);
            try {
                String string;
                long l = System.currentTimeMillis();
                LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.sFileScript));
                while ((string = Log.readLine(lineNumberReader)) != null) {
                    this.dDatabase.execute(string, this.cSystem);
                }
                lineNumberReader.close();
                l = System.currentTimeMillis() - l;
            }
            catch (IOException iOException) {
                throw Trace.error(28, this.sFileScript + " " + iOException);
            }
            this.dDatabase.setReferencialIntegrity(true);
            this.bRestoring = false;
        }
    }

    private void writeScript(boolean bl) throws SQLException {
        new File(this.sFileScript + ".new").delete();
        Log.scriptToFile(this.dDatabase, this.sFileScript + ".new", bl, this.cSystem);
    }

    private static void writeLine(Writer writer, String string) throws IOException {
        writer.write(StringConverter.unicodeToAscii(string) + "\r\n");
    }

    private static String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        return StringConverter.asciiToUnicode(string);
    }

    Log(Database database, Channel channel, String string) throws SQLException {
        this.dDatabase = database;
        this.cSystem = channel;
        this.sName = string;
        this.sFileProperties = this.sName + ".properties";
        this.pProperties = new Properties();
        this.tRunner = new Thread(this);
        this.tRunner.start();
    }
}

