/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind._hy;
import com.evermind._lfb;
import com.evermind._me;
import com.evermind._sp;
import com.evermind._ub;
import com.evermind._uc;
import com.evermind._vc;
import com.evermind._vd;
import com.evermind.io.IOUtils;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileNamingEnumeration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class FileContext
extends _ub
implements _lfb,
_hy,
_uc {
    public File _gu;
    public Map _pkc;
    public boolean _qid = true;
    public boolean _ead = true;

    protected Object _oy(File file) throws IOException, NamingException {
        return file;
    }

    public Context _lm(String string) throws NamingException {
        if (this._gu != null && string.equals(this._gu.getName())) {
            throw new NamingException("Relative was myself");
        }
        String string2 = this._gu.getPath().substring(0, this._gu.getPath().lastIndexOf(File.separator) + 1) + string;
        File file = new File(string2);
        if (!file.exists()) {
            throw new NamingException("Relative " + string + " does not exist (" + string2 + ")");
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file.isDirectory()) {
            if (this instanceof ContentFileContext) {
                return new ContentFileContext(file, null);
            }
            if (this instanceof _vd) {
                return new _vd(file, null);
            }
            return new FileContext(file, null);
        }
        if (this instanceof ContentFileContext) {
            try {
                return _sp._fa(new ContentFileContext(this._gu.getParentFile(), this._pkc), string, false);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this instanceof _vd) {
            return new _vc(file, false);
        }
        return new _me(file, false);
    }

    public URL _jtb(String string) {
        File file = this._ry(string);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Object removeFromEnvironment(String string) {
        return this._pkc.remove(string);
    }

    public Hashtable getEnvironment() {
        return new Hashtable(this._pkc);
    }

    public void unbind(String string) throws NamingException {
        File file = this._ry(string);
        if (!file.exists()) {
            throw new NameNotFoundException(string);
        }
        file.delete();
    }

    public int hashCode() {
        return this._gu.hashCode() + 8;
    }

    protected Context _lhd(File file) {
        return new FileContext(file, this._pkc == null ? null : new Hashtable(this._pkc));
    }

    public NamingEnumeration list(String string) throws NamingException {
        File file;
        if (string.equals("")) {
            file = this._gu;
        } else {
            file = this._ry(string);
            if (!file.exists()) {
                throw new NameNotFoundException(string);
            }
            if (!file.isDirectory()) {
                throw new NamingException("Not a directory");
            }
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new NameNotFoundException("No such directory: '" + file.getPath() + "'");
        }
        return new FileNamingEnumeration(fileArray, this);
    }

    public String getNameInNamespace() throws NamingException {
        return this._gu.getPath();
    }

    protected void _ru(File file, Object object) throws IOException, NamingException {
        if (object instanceof File && ((File)object).isDirectory()) {
            file.mkdir();
        } else {
            file.createNewFile();
        }
    }

    public Object addToEnvironment(String string, Object object) {
        return this._pkc.put(string, object);
    }

    public boolean _rw(String string, long l) throws IOException {
        return this._ry(string).setLastModified(l);
    }

    public long _lw(String string) {
        return this._ry(string).lastModified();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileContext)) {
            return false;
        }
        return ((FileContext)object)._gu.equals(this._gu);
    }

    public Object lookupLink(String string) {
        throw new UnsupportedOperationException("lookupLink() is not supported");
    }

    public File _ry() {
        return this._gu;
    }

    public void destroySubcontext(String string) throws NamingException {
        File file = this._ry(string);
        if (!file.exists()) {
            throw new NameNotFoundException(string);
        }
        if (!file.isDirectory()) {
            throw new NotContextException(string);
        }
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            throw new ContextNotEmptyException(string);
        }
        if (!file.delete()) {
            throw new NamingException("Directory removal failed");
        }
    }

    public File _ry(String string) {
        return new File(this._gu.getPath() + File.separatorChar + string.replace('/', File.separatorChar));
    }

    public NamingEnumeration listBindings(String string) {
        throw new UnsupportedOperationException("listBindings() is not supported");
    }

    public void close() {
    }

    public String toString() {
        return this._gu.toString();
    }

    public FileContext(File file, Map map) {
        this._gu = file;
        this._pkc = map;
    }

    public void bind(String string, Object object) throws NamingException {
        this._ege(string, false);
        this._sc(string, object, this._ry(string));
    }

    public void _sc(String string, Object object, File file) throws NamingException {
        if (file.exists()) {
            throw new NameAlreadyBoundException(file.toString());
        }
        try {
            this._ru(file, object);
        }
        catch (IOException iOException) {
            throw new NamingException("IO Error: " + iOException.getMessage());
        }
    }

    public void rebind(String string, Object object) throws NamingException {
        this._ege(string, false);
        File file = this._ry(string);
        file.delete();
        this._sc(string, object, file);
    }

    public boolean _mc(String string) {
        return this._ry(string).exists();
    }

    public Context createSubcontext(String string) throws NamingException {
        File file = this._ry(string);
        if (file.exists()) {
            throw new NameAlreadyBoundException(string);
        }
        this._ege(string, true);
        if (!file.mkdir() && !file.exists()) {
            throw new NamingException("Unable to create directory");
        }
        try {
            return this._lhd(file.getCanonicalFile());
        }
        catch (IOException iOException) {
            throw new NamingException("IO error: " + iOException.getMessage());
        }
    }

    protected void _ege(String string, boolean bl) throws NamingException {
        File file = new File(this._gu.getPath() + File.separator + string);
        if (!file.getParentFile().exists()) {
            if (!this._qid) {
                throw new NameNotFoundException("Parent directory does not exist: " + string);
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            File file2 = file.getParentFile();
            while (!file2.exists()) {
                arrayList.add(file2);
                file2 = file2.getParentFile();
            }
            int n = arrayList.size() - 1;
            while (n >= 0) {
                ((File)arrayList.get(n)).mkdir();
                --n;
            }
        }
        if (bl && !file.exists() && !file.mkdir()) {
            if (!this._qid) {
                throw new NameNotFoundException("Directory does not exist: " + string);
            }
            throw new NamingException("Unable to create directory");
        }
    }

    public Object lookup(String string) throws NamingException {
        File file = this._ry(string);
        try {
            if (!file.exists() || this._ead && !file.getCanonicalFile().getPath().endsWith(string.replace('/', File.separatorChar))) {
                throw new NameNotFoundException(string);
            }
        }
        catch (IOException iOException) {
            throw new NamingException("IO error: " + iOException.getMessage());
        }
        if (file.isDirectory()) {
            try {
                return this._lhd(file.getCanonicalFile());
            }
            catch (IOException iOException) {
                throw new NamingException("IO error: " + iOException.getMessage());
            }
        }
        try {
            return this._oy(file);
        }
        catch (IOException iOException) {
            throw new NamingException("IO Error: " + iOException.getMessage());
        }
    }

    public void rename(String string, String string2) throws NamingException {
        if (string.equals(string2)) {
            return;
        }
        try {
            Object object2;
            this._ege(string2, false);
            File file = this._ry(string);
            File file2 = this._ry(string2);
            if (!file.exists()) {
                throw new NameNotFoundException(file.toString());
            }
            if (file2.exists()) {
                throw new NameAlreadyBoundException(file2.toString());
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                Object var9_9;
                object2 = new FileOutputStream(file2);
                try {
                    IOUtils._ajb(fileInputStream, (OutputStream)object2);
                }
                finally {
                    var9_9 = null;
                    try {
                        ((OutputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
                var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException object2) {}
        }
        catch (IOException iOException) {
            throw new NamingException("IO Error: " + iOException.getMessage());
        }
    }
}

