/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.security;

import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserAlreadyExistsException;
import com.evermind.security.UserManager;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractUserManager
implements UserManager {
    public Set _cjc;
    public Set _ckc;
    public UserManager parent;

    public List getGroups(int n, int n2) {
        throw new UnsupportedOperationException("getGroups() is not supported by this UserManager");
    }

    public User getAdminUser() {
        if (this.parent != null) {
            return this.parent.getAdminUser();
        }
        return null;
    }

    public Group createGroup(String string) throws InstantiationException {
        if (this.parent != null) {
            return this.parent.createGroup(string);
        }
        throw new InstantiationException("This UserManager cannot create new groups");
    }

    public int getUserCount() {
        throw new UnsupportedOperationException("getUserCount() is not supported by this UserManager");
    }

    public int getGroupCount() {
        throw new UnsupportedOperationException("getGroupCount() is not supported by this UserManager");
    }

    public void invalidate() {
    }

    public List getUsers(int n, int n2) {
        throw new UnsupportedOperationException("getUsers() is not supported by this UserManager");
    }

    public void setParent(UserManager userManager) {
        this.parent = userManager;
    }

    public UserManager getParent() {
        return this.parent;
    }

    public boolean isUpdated() {
        return false;
    }

    public void create(URL uRL) {
    }

    public void store() {
    }

    public User getUser(String string) {
        if (this.parent != null) {
            return this.parent.getUser(string);
        }
        return null;
    }

    public User getUser(String string, BigInteger bigInteger) {
        if (this.parent != null) {
            return this.parent.getUser(string, bigInteger);
        }
        return null;
    }

    public User getUser(X509Certificate x509Certificate) {
        return this.getUser(x509Certificate.getIssuerDN().getName(), x509Certificate.getSerialNumber());
    }

    public void addDefaultGroup(String string) {
        if (this._ckc == null) {
            this._ckc = new HashSet();
        }
        this._ckc.add(string);
        this._cjc = null;
    }

    public void update() {
    }

    public User getAnonymousUser() {
        if (this.parent != null) {
            return this.parent.getAnonymousUser();
        }
        return null;
    }

    public User createUser(String string, String string2) throws InstantiationException, UserAlreadyExistsException {
        throw new UnsupportedOperationException("this UserManager cannot create users");
    }

    public boolean containsDefaultGroup(String string) {
        if (this._ckc == null) {
            return false;
        }
        return this._ckc.contains(string);
    }

    public Group getGroup(String string) {
        if (this.parent != null) {
            return this.parent.getGroup(string);
        }
        return null;
    }

    public void init(Properties properties) throws InstantiationException {
    }

    public Set getDefaultGroups() {
        if (this._ckc == null) {
            return Collections.EMPTY_SET;
        }
        if (this._cjc == null) {
            this._cjc = new HashSet();
            Iterator iterator = this._ckc.iterator();
            while (iterator.hasNext()) {
                Group group = this.getGroup((String)iterator.next());
                if (group == null) continue;
                this._cjc.add(group);
            }
        }
        return this._cjc;
    }

    public boolean remove(User user) {
        return false;
    }

    public boolean remove(Group group) {
        return false;
    }
}

