/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.EnvironmentPropertyDescription;
import com.evermind.server.deployment.ResourceInfo;
import com.evermind.server.deployment.ResourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ContextScanningResourceProvider
implements ResourceProvider {
    public String _dg;
    public Context _gt;
    public Map _vh = new HashMap();
    public Set _qsc;
    public static Class _qtc;
    public static Class _quc;
    public static Class _qvc;
    public static Class _qwc;
    public static Class _qxc;
    public static Class _qyc;
    public static Class _qzc;
    public static Class _rac;
    public static Class _rbc;

    public EnvironmentPropertyDescription[] getPropertyDescriptions() {
        return null;
    }

    public String getDescription() {
        return "A resource provider that supplies the content of an arbitary context specified by the init parameters. For init parameter values see the JNDI API.";
    }

    public ResourceInfo getDefaultResource(String string) {
        List list = (List)this._vh.get(string);
        if (list != null) {
            return (ResourceInfo)list.get(0);
        }
        return null;
    }

    public Set getResources(String string) {
        return new HashSet((Collection)this._vh.get(string));
    }

    public Object getResource(String string) throws InstantiationException {
        try {
            return this._gt.lookup(string);
        }
        catch (NamingException namingException) {
            throw new InstantiationException("Error looking up resource '" + string + "': " + namingException.getMessage());
        }
    }

    protected void bindContext(Context context, String string) throws NamingException {
        NamingEnumeration namingEnumeration = context.list(new CompositeName());
        while (namingEnumeration.hasMore()) {
            Class<?> clazz;
            NameClassPair nameClassPair = (NameClassPair)namingEnumeration.next();
            String string2 = nameClassPair.getName();
            String string3 = nameClassPair.getClassName();
            try {
                clazz = Class.forName(string3, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = context.lookup(string2).getClass();
            }
            this._mld(clazz, string, string2);
        }
    }

    public Set getHandledTypes() {
        return this._vh.keySet();
    }

    protected void _mld(Class clazz, String string, String string2) {
        if ((_qtc != null ? _qtc : (_qtc = ContextScanningResourceProvider.class$("javax.sql.DataSource"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.sql.DataSource", string, string2);
        }
        if ((_quc != null ? _quc : (_quc = ContextScanningResourceProvider.class$("javax.sql.XADataSource"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.sql.XADataSource", string, string2);
        }
        if ((_qvc != null ? _qvc : (_qvc = ContextScanningResourceProvider.class$("javax.sql.ConnectionPoolDataSource"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.sql.ConnectionPoolDataSource", string, string2);
        }
        if ((_qwc != null ? _qwc : (_qwc = ContextScanningResourceProvider.class$("javax.jms.Queue"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.jms.Queue", string, string2);
        }
        if ((_qxc != null ? _qxc : (_qxc = ContextScanningResourceProvider.class$("javax.jms.Topic"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.jms.Topic", string, string2);
        }
        if ((_qyc != null ? _qyc : (_qyc = ContextScanningResourceProvider.class$("javax.jms.QueueConnectionFactory"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.jms.QueueConnectionFactory", string, string2);
        }
        if ((_qzc != null ? _qzc : (_qzc = ContextScanningResourceProvider.class$("javax.jms.TopicConnectionFactory"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.jms.TopicConnectionFactory", string, string2);
        }
        if ((_rac != null ? _rac : (_rac = ContextScanningResourceProvider.class$("javax.jms.XAQueueConnectionFactory"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.jms.XAQueueConnectionFactory", string, string2);
        }
        if ((_rbc != null ? _rbc : (_rbc = ContextScanningResourceProvider.class$("javax.jms.XATopicConnectionFactory"))).isAssignableFrom(clazz)) {
            this.bindResource("javax.jms.XATopicConnectionFactory", string, string2);
        }
    }

    private static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getDisplayName() {
        return "Context resource provider for " + (this._gt == null ? "<generic context>" : this._gt.toString());
    }

    public void setName(String string) {
        this._dg = string;
    }

    public String getName() {
        return this._dg;
    }

    protected void bindResource(String string, String string2, String string3) {
        if (this._qsc != null && !this._qsc.contains(string)) {
            return;
        }
        ArrayList<ResourceInfo> arrayList = (ArrayList<ResourceInfo>)this._vh.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<ResourceInfo>();
        }
        arrayList.add(new ResourceInfo(string2.length() == 0 ? string3 : string2 + "/" + string3));
        if (arrayList.size() == 1) {
            this._vh.put(string, arrayList);
        }
    }

    public void init(Map map) throws InstantiationException {
        String string;
        StringTokenizer stringTokenizer;
        InitialContext initialContext;
        String string2 = (String)map.remove("resource.names");
        String string3 = (String)map.remove("resource.types");
        try {
            initialContext = new InitialContext(new Hashtable(map));
        }
        catch (NamingException namingException) {
            throw new InstantiationException("Error creating naming context instance: " + namingException);
        }
        if (string3 != null) {
            this._qsc = new HashSet();
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                this._qsc.add(string);
            }
        }
        if (string2 != null) {
            this._gt = initialContext;
            stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                string = stringTokenizer.nextToken();
                try {
                    object = initialContext.lookup(string);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw new InstantiationException("Resource '" + string + "' as specified by resource.names not found");
                }
                catch (NamingException namingException) {
                    throw new InstantiationException("Error looking up resource '" + string + "': " + namingException.getMessage());
                }
                this._mld(object.getClass(), "", string);
            }
        } else {
            this.setContext(initialContext);
        }
    }

    protected void setContext(Context context) throws InstantiationException {
        this._gt = context;
        try {
            this.bindContext(context, "");
        }
        catch (NamingException namingException) {
            throw new InstantiationException("Error traversing naming context instance: " + namingException);
        }
    }
}

