/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.security.User;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.LocalStatefulSessionEJBHome;
import com.evermind.server.ejb.SessionMigratedException;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionHandle;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.rmi.OrionRemoteException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.transaction.SystemException;

public abstract class StatefulSessionEJBObject
extends AbstractEJBObject {
    public long _ap;
    public long _tjb;
    public long creationTime;
    public long lastAccessedTime;
    public boolean invalidated;
    public boolean _kvb;
    public StatefulSessionContext context;
    public User _fvb;

    public boolean isRecursive() {
        return false;
    }

    protected void throwPassivisationException() throws NoSuchObjectException {
        if (this._kvb) {
            throw new SessionMigratedException("Session has migrated");
        }
        throw new NoSuchObjectException("Session has timed out");
    }

    protected void throwLocalPassivisationException() {
        if (this._kvb) {
            throw new EJBException("Session has migrated");
        }
        throw new EJBException("Session has timed out");
    }

    public abstract void setObject(SessionBean var1);

    public synchronized void _uwd(boolean bl) {
        StatefulSessionEJBHome statefulSessionEJBHome = this.context.home;
        synchronized (statefulSessionEJBHome) {
            if (this.invalidated) {
                Object var4_3 = null;
                return;
            }
            this.context.home.instances._js(this._ap);
            try {
                this.removeSessionObject();
            }
            catch (Throwable throwable) {
                this.context.home.log("Error in ejbRemove()", throwable);
            }
            this.invalidated = true;
            Object var4_4 = null;
        }
    }

    public abstract void removeSessionObject() throws Throwable;

    public void log(String string, Throwable throwable) {
        this.context.home.log(string, throwable);
    }

    public String toString() {
        return "session " + this._ap;
    }

    public StatefulSessionEJBObject(StatefulSessionContext statefulSessionContext, User user) {
        this.context = statefulSessionContext;
        statefulSessionContext.wrapper = this;
        this.lastAccessedTime = this.creationTime = StatefulSessionEJBObject.getCurrentTime();
        this._ap = statefulSessionContext.home._kgc();
        this._fvb = user;
    }

    public StatefulSessionEJBObject(StatefulSessionContext statefulSessionContext, long l, long l2, User user) {
        this.context = statefulSessionContext;
        this.context.wrapper = this;
        this._ap = l;
        this._tjb = l2;
        this._fvb = user;
    }

    public int hashCode() {
        return (int)this._ap;
    }

    public boolean _aqc() {
        return this.invalidated;
    }

    public synchronized Handle getHandle() throws RemoteException {
        this.lastAccessedTime = StatefulSessionEJBObject.getCurrentTime();
        StatefulSessionHandle statefulSessionHandle = new StatefulSessionHandle(this, this.context.home instanceof LocalStatefulSessionEJBHome);
        statefulSessionHandle.id = this._ap;
        if (this._tjb == 0L) {
            this._tjb = Double.doubleToLongBits(Math.random());
            if (this._tjb == 0L) {
                ++this._tjb;
            }
        }
        statefulSessionHandle.checksum = this._tjb;
        statefulSessionHandle.homePath = this.context.home.getBindingPath();
        return statefulSessionHandle;
    }

    public void addToInstances() {
        StatefulSessionEJBHome statefulSessionEJBHome = this.context.home;
        synchronized (statefulSessionEJBHome) {
            this.context.home.instances._nh(this._ap, this);
            Object var2_2 = null;
        }
    }

    public void endTransaction(ThreadState threadState, boolean bl) throws RemoteException {
        block7: {
            try {
                if (this.context == null || this.context.object == null || !(this.context.object instanceof SessionSynchronization)) break block7;
                ((SessionSynchronization)((Object)this.context.object)).afterCompletion(bl);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                StatefulSessionEJBObject statefulSessionEJBObject = this;
                synchronized (statefulSessionEJBObject) {
                    block9: {
                        this.transaction = null;
                        if (this.currentCaller != null) break block9;
                        this.notifyNextCaller();
                    }
                    Object var6_8 = null;
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        StatefulSessionEJBObject statefulSessionEJBObject = this;
        synchronized (statefulSessionEJBObject) {
            block8: {
                this.transaction = null;
                if (this.currentCaller != null) break block8;
                this.notifyNextCaller();
            }
            Object var6_7 = null;
        }
    }

    public Object getPrimaryKey() throws RemoteException {
        throw new OrionRemoteException("Session beans do not have primary keys");
    }

    public abstract SessionBean passivate() throws Exception;

    public boolean isIdentical(EJBObject eJBObject) throws RemoteException {
        if (this.invalidated) {
            this.throwPassivisationException();
        }
        this.lastAccessedTime = StatefulSessionEJBObject.getCurrentTime();
        return eJBObject.getClass() == this.getClass() && ((StatefulSessionEJBObject)eJBObject)._ap == this._ap;
    }

    public EJBHome getEJBHome() {
        return this.context.home;
    }

    public final void beforeCompletion() throws RemoteException {
        if (this.context != null && this.context.object != null && this.context.object instanceof SessionSynchronization) {
            ((SessionSynchronization)((Object)this.context.object)).beforeCompletion();
        }
    }

    protected void _uic() {
        this.lastAccessedTime = StatefulSessionEJBObject.getCurrentTime();
    }

    public void afterBegin() throws RemoteException {
        if (this.context != null && this.context.object != null && this.context.object instanceof SessionSynchronization) {
            ((SessionSynchronization)((Object)this.context.object)).afterBegin();
        }
    }

    public synchronized void remove() throws RemoteException, RemoveException {
        if (this.invalidated) {
            this.throwPassivisationException();
        }
        ThreadState threadState = ThreadState.getCurrentState();
        ContextContainer contextContainer = threadState.contextContainer;
        if (this.transaction != null) {
            try {
                throw new RemoveException("Cannot remove a session that is a part of an active transaction (Transaction id: " + this.transaction._hyd() + ", status: " + ApplicationServerTransaction._uxd(this.transaction.getStatus()) + ")");
            }
            catch (SystemException systemException) {
                throw new RemoveException("Cannot remove a session that is a part of an active transaction (Transaction id: " + this.transaction._hyd() + ")");
            }
        }
        try {
            threadState.contextContainer = this.context.home;
            this._uwd(false);
        }
        finally {
            Object var5_4 = null;
            threadState.contextContainer = contextContainer;
        }
    }

    public static long getCurrentTime() {
        return HttpDateFormat._vlb();
    }
}

