/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.ssl;

import com.evermind.ssl.SSLServerSocketFactory;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;

public class JSSESSLServerSocketFactory
implements SSLServerSocketFactory {
    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress, Properties properties, Properties properties2, byte[] byArray) throws IOException {
        String string;
        if (properties == null) {
            properties = new Properties();
        }
        if ((string = properties.getProperty("provider")) != null && Security.getProvider(string) == null) {
            try {
                Security.addProvider((Provider)Class.forName(string).newInstance());
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Unable to instantiate provider " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Unable to instantiate provider " + string + " (IllegalAccessException)");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Provider " + string + " not foud");
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Class " + string + " is not an instance of java.security.Provider");
            }
        }
        if (string == null || string.equals("com.sun.net.ssl.internal.ssl.Provider")) {
            if (byArray == null) {
                throw new IOException("No keystore specified");
            }
            javax.net.ssl.SSLServerSocketFactory sSLServerSocketFactory = null;
            try {
                String string2 = properties.getProperty("protocol", "TLS");
                String string3 = properties.getProperty("algorithm", "SunX509");
                String string4 = properties.getProperty("keyStore.type", "JKS");
                String string5 = properties.getProperty("keyStore.password");
                if (string5 == null) {
                    throw new IOException("keyStore.password not set");
                }
                SSLContext sSLContext = SSLContext.getInstance(string2);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string3);
                KeyStore keyStore = KeyStore.getInstance(string4);
                char[] cArray = string5.toCharArray();
                keyStore.load(new ByteArrayInputStream(byArray), cArray);
                keyManagerFactory.init(keyStore, cArray);
                sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
                sSLServerSocketFactory = sSLContext.getServerSocketFactory();
                SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n, n2, inetAddress);
                if ("true".equalsIgnoreCase(properties.getProperty("needs-client-auth"))) {
                    sSLServerSocket.setNeedClientAuth(true);
                }
                sSLServerSocket.setEnableSessionCreation(true);
                return sSLServerSocket;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("No such algorithm: " + noSuchAlgorithmException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                throw new IOException("Key-store error: " + keyStoreException.getMessage());
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new IOException("Unrecoverable key error: " + unrecoverableKeyException.getMessage());
            }
            catch (KeyManagementException keyManagementException) {
                throw new IOException("Key management error: " + keyManagementException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new IOException("Certificate error: " + certificateException.getMessage());
            }
        }
        SSLServerSocket sSLServerSocket = (SSLServerSocket)javax.net.ssl.SSLServerSocketFactory.getDefault().createServerSocket(n, n2, inetAddress);
        sSLServerSocket.setEnableSessionCreation(true);
        sSLServerSocket.setNeedClientAuth(false);
        sSLServerSocket.setSoTimeout(15000);
        return sSLServerSocket;
    }
}

