/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import com.evermind.server.ApplicationServerThread;
import com.evermind.server.http.ServletInstanceInfo;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

public class UnavailableException
extends ServletException {
    private Servlet servlet;
    private int seconds;

    public UnavailableException(Servlet servlet, String message) {
        super(message);
        this.servlet = servlet;
        this.seconds = -1;
    }

    public UnavailableException(String message) {
        super(message);
        this.servlet = this.getCallerServlet();
        this.seconds = -1;
    }

    public UnavailableException(String message, int seconds) {
        super(message);
        this.servlet = this.getCallerServlet();
        this.seconds = seconds;
    }

    protected Servlet getCallerServlet() {
        try {
            ServletInstanceInfo info;
            Thread thread = Thread.currentThread();
            if (thread instanceof ApplicationServerThread && (info = ((ApplicationServerThread)thread).servletInfo) != null) {
                return info.servlet;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public UnavailableException(int seconds, Servlet servlet, String msg) {
        super(msg);
        this.servlet = servlet;
        this.seconds = seconds;
    }

    public int getUnavailableSeconds() {
        if (this.seconds == 0) {
            return -1;
        }
        return this.seconds;
    }

    public boolean isPermanent() {
        return this.seconds <= 0;
    }

    public Servlet getServlet() {
        return this.servlet;
    }
}

