package com.evermind.ejb;

import java.util.*;
import java.rmi.RemoteException;
import javax.ejb.*;

public class NewsItemEJB implements EntityBean
{
	protected EntityContext context;

	public int id; // Integer primary key for convenience
	public NewsItem parent; // The parent, null if this is not a reply
	public String submitter; // User who submitted the article
	public String subject; // Subject of the article
	public String text; // Content/body of the article
	public Date date; // Time it was created/posted
	public Locale locale; // Locale of the user submitting it

	public void ejbPostCreate(int id)
	{
		this.id = id;
		this.submitter = this.context.getCallerPrincipal().getName();
	}

	public java.lang.Integer ejbCreate(NewsItem parent, Date date, String subject, String text) throws CreateException
	{
		this.parent = parent;
		this.date = date;
		this.id = (int)(date.getTime() / 100);
		this.subject = subject;
		this.text = text;
		this.locale = new Locale("en", "US");
		this.submitter = this.context.getCallerPrincipal().getName();
		return null; // Return null when using CMP
	}

	public void ejbPostCreate(NewsItem parent, Date date, String subject, String text)
	{
	}

	public int getId()
	{
		return id;
	}

	public NewsItem getParent()
	{
		return parent;
	}

	public String getSubject()
	{
		return subject;
	}

	public String getSubmitter()
	{
		return submitter;
	}

	public void setSubject(String value)
	{
		this.subject = value;
	}

	public String getText()
	{
		return text;
	}

	public void setText(String value)
	{
		this.text = value;
	}

	public java.util.Date getDate()
	{
		return date;
	}

	public void setDate(java.util.Date value)
	{
		this.date = value;
	}

	public Locale getLocale()
	{
		return locale;
	}

	public void setLocale(Locale locale)
	{
		this.locale = locale;
	}

	public void ejbLoad()
	{
	}

	public void ejbStore()
	{
	}

	public void ejbActivate()
	{
	}

	public void ejbPassivate()
	{
	}

	public void ejbRemove()
	{
	}

	public void setEntityContext(EntityContext context)
	{
		this.context = context;
	}

	public void unsetEntityContext()
	{
		this.context = null;
	}

	public java.lang.Integer ejbCreate(int id) throws CreateException
	{
		this.id = id;
		return null; // Return null when using CMP
	}

	public NewsView getView() throws RemoteException
	{
		return new NewsView(id, parent == null ? 0 : parent.getId(), submitter, subject, text, date, locale);
	}
}
