import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
/**
 * A simple client for accessing a Cart.
 */
public class CartClient
{
	public static void main(String[] args)
	{
		try
		{
			/**
			 * Create access to the naming context.
			 */
			Context context = new InitialContext();

			/**
			 * Lookup the CartHome object. The reference should be retrieved from the
			 * application-local context (java:comp/env, the variable is
			 * specified in the assembly descriptor; META-INF/application-client.xml)
			 * but for simplicity we use a global variable.
			 */
			Object homeObject = context.lookup("java:comp/env/MyCart");

			// Narrow the reference to a CartHome.
			CartHome home = (CartHome)PortableRemoteObject.narrow(homeObject, CartHome.class);

			// Create a new Cart and narrow the reference.
			Cart cart = (Cart)PortableRemoteObject.narrow(home.create(), Cart.class);
		
			// Add some items to the Cart.
			cart.add("Milk");
			cart.add("Apples");
			cart.add("Pizza");
		
			// Remove an item.
			cart.remove("Apples");
		
			// Remove an unexistant item from the Cart, will generate a NotInCartException.
			cart.remove("Oranges");
		}
		catch(RemoteException e)
		{
			System.err.println("System/communication error: " + e.getMessage());
		}
		catch(NamingException e)
		{
			System.err.println("Communication error: " + e.getMessage());
		}
		catch(CreateException e)
		{
			System.err.println("Error creating cart: " + e.getMessage());
		}
		catch(NotInCartException e)
		{
			System.err.println("Item not found in cart: " + e.getMessage());
		}
	}
}
