import java.net.*;
import java.util.*;
import javax.naming.*;
import java.io.*;

/**
 * A demo app example describing how to interact with the RMI-server.
 */
public class RMIApp
{
	public static void main(String[] args) throws Throwable
	{
		Hashtable environment = new Hashtable();

		// Specify the emd-rmi SPI
		environment.put("java.naming.factory.initial", "com.evermind.server.rmi.RMIInitialContextFactory");

		// Specify the host
		environment.put("host", "the.remote.server.com");
		
		// Specify username - this must be an admin account on the remote server
		environment.put("username", "adminUser");
		
		// Password
		environment.put("password", "123abc");

		InitialContext context = new InitialContext(environment);

		for(int i = 0; i < 10; i++)
		{
			com.evermind.ejb.EJBUserHome home = (com.evermind.ejb.EJBUserHome)context.lookup("com.evermind.ejb.EJBUser");
			System.out.println("Home: " + home);

			com.evermind.ejb.EJBUser user = home.findByPrimaryKey(new com.evermind.ejb.EJBUserID("anewuser"));
			System.out.println("User: " + user.getName());
		}
	}
}
