<%@ page session="false" %>

<html>
	<head>
		<title>User-adding (SSL) example</title>
	</head>

	<body bgcolor="ffffff">
		This example shows how to use of request attributes.<br>
		<br>
			Username: <jsp:getProperty name="request" property="userPrincipal:name" /><br>
			User language: <jsp:getProperty name="request" property="locale:displayLanguage" /><br>
			User country: <jsp:getProperty name="request" property="locale:displayCountry" /><br>
			User host: <jsp:getProperty name="request" property="remoteHost" /><br>

			<% java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)request.getAttribute("javax.servlet.request.X509Certificate"); %>
			
			<%
				com.evermind.security.UserManager manager = (com.evermind.security.UserManager)application.getAttribute("user.manager");

				if(request.getParameter("username") != null && manager.getUser(request.getParameter("username")) == null)
				{
					com.evermind.security.User user = manager.createUser(request.getParameter("username"), request.getParameter("password"));
					
					if(cert != null)
					{
						user.setCertificate(cert.getIssuerDN().getName(), cert.getSerialNumber());
					}

					out.println("ADDED " + request.getParameter("username") + "<br>");
				}
			%>
			User cert: <%= cert != null ? cert.getSubjectDN() : "" %><br>
			User ID: <%= "" + cert != null ? cert.getSerialNumber() : "" %><br>
			
			<br>
			<form action="<%=request.getRequestURI()%>">
				<b>Username:</b> <input type="text" name="username"><br>
				<b>Password:</b> <input type="password" name="password"><br>
				
				<input type="Submit" value="Add">
			</form>
	</body>
</html>