/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind._in;
import com.evermind._mf;
import com.evermind._mnb;
import com.evermind._tf;
import com.evermind._uw;
import com.evermind._ux;
import com.evermind._vs;
import com.evermind._vt;
import com.evermind.io.IOUtils;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileNamingEnumeration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class FileContext
extends _uw
implements _mnb,
_in,
_ux {
    public File _ha;
    public Map _scc;
    public boolean _vhd = true;
    public boolean _hnd = true;
    public static final boolean _vid = FileContext._oae();

    protected Object _pq(File file) throws IOException, NamingException {
        return file;
    }

    public Context _mm(String string) throws NamingException {
        if (this._ha != null && string.equals(this._ha.getName())) {
            throw new NamingException("Relative was myself");
        }
        String string2 = this._ha.getPath().substring(0, this._ha.getPath().lastIndexOf(File.separator) + 1) + string;
        File file = new File(string2);
        if (!file.exists()) {
            throw new NamingException("Relative " + string + " does not exist (" + string2 + ")");
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file.isDirectory()) {
            if (this instanceof ContentFileContext) {
                return new ContentFileContext(file, null);
            }
            if (this instanceof _vt) {
                return new _vt(file, null);
            }
            return new FileContext(file, null);
        }
        if (this instanceof ContentFileContext) {
            try {
                return _tf._ff(new ContentFileContext(this._ha.getParentFile(), this._scc), string, false);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this instanceof _vt) {
            return new _vs(file, false);
        }
        return new _mf(file, false);
    }

    public URL _ksb(String string) {
        File file = this._sp(string);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Object removeFromEnvironment(String string) {
        return this._scc.remove(string);
    }

    public Hashtable getEnvironment() {
        return new Hashtable(this._scc);
    }

    public void unbind(String string) throws NamingException {
        File file = this._sp(string);
        if (!file.exists()) {
            throw new NameNotFoundException(string);
        }
        file.delete();
    }

    public int hashCode() {
        return this._ha.hashCode() + 8;
    }

    protected Context _tld(File file) {
        return new FileContext(file, this._scc == null ? null : new Hashtable(this._scc));
    }

    public NamingEnumeration list(String string) throws NamingException {
        File file;
        if (string.equals("")) {
            file = this._ha;
        } else {
            file = this._sp(string);
            if (!file.exists()) {
                throw new NameNotFoundException(string);
            }
            if (!file.isDirectory()) {
                throw new NamingException("Not a directory");
            }
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new NameNotFoundException("No such directory: '" + file.getPath() + "'");
        }
        return new FileNamingEnumeration(fileArray, this);
    }

    public String getNameInNamespace() throws NamingException {
        return this._ha.getPath();
    }

    protected void _sl(File file, Object object) throws IOException, NamingException {
        if (object instanceof File && ((File)object).isDirectory()) {
            file.mkdir();
        } else {
            file.createNewFile();
        }
    }

    public Object addToEnvironment(String string, Object object) {
        return this._scc.put(string, object);
    }

    public boolean _sn(String string, long l) throws IOException {
        return this._sp(string).setLastModified(l);
    }

    public long _ms(String string) {
        return this._sp(string).lastModified();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileContext)) {
            return false;
        }
        return ((FileContext)object)._ha.equals(this._ha);
    }

    private static boolean _oae() {
        return File.separatorChar != '/';
    }

    public Object lookupLink(String string) {
        throw new UnsupportedOperationException("lookupLink() is not supported");
    }

    public File _sp() {
        return this._ha;
    }

    public void destroySubcontext(String string) throws NamingException {
        File file = this._sp(string);
        if (!file.exists()) {
            throw new NameNotFoundException(string);
        }
        if (!file.isDirectory()) {
            throw new NotContextException(string);
        }
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            throw new ContextNotEmptyException(string);
        }
        if (!file.delete()) {
            throw new NamingException("Directory removal failed");
        }
    }

    public File _sp(String string) {
        return new File(this._ha.getPath() + File.separatorChar + string.replace('/', File.separatorChar));
    }

    public NamingEnumeration listBindings(String string) {
        throw new UnsupportedOperationException("listBindings() is not supported");
    }

    public void close() {
    }

    public String toString() {
        return this._ha.toString();
    }

    public FileContext(File file, Map map) {
        this._ha = file;
        this._scc = map;
    }

    public void bind(String string, Object object) throws NamingException {
        this._obe(string, false);
        this._st(string, object, this._sp(string));
    }

    public void _st(String string, Object object, File file) throws NamingException {
        if (file.exists()) {
            throw new NameAlreadyBoundException(file.toString());
        }
        try {
            this._sl(file, object);
        }
        catch (IOException iOException) {
            throw new NamingException("IO Error: " + iOException.getMessage());
        }
    }

    public void rebind(String string, Object object) throws NamingException {
        this._obe(string, false);
        File file = this._sp(string);
        file.delete();
        this._st(string, object, file);
    }

    public boolean _my(String string) {
        return this._sp(string).exists();
    }

    public Context createSubcontext(String string) throws NamingException {
        File file = this._sp(string);
        if (file.exists()) {
            throw new NameAlreadyBoundException(string);
        }
        this._obe(string, true);
        if (!file.mkdir() && !file.exists()) {
            throw new NamingException("Unable to create directory");
        }
        try {
            return this._tld(file.getCanonicalFile());
        }
        catch (IOException iOException) {
            throw new NamingException("IO error: " + iOException.getMessage());
        }
    }

    protected void _obe(String string, boolean bl) throws NamingException {
        File file = new File(this._ha.getPath() + File.separator + string);
        if (!file.getParentFile().exists()) {
            if (!this._vhd) {
                throw new NameNotFoundException("Parent directory does not exist: " + string);
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            File file2 = file.getParentFile();
            while (!file2.exists()) {
                arrayList.add(file2);
                file2 = file2.getParentFile();
            }
            int n = arrayList.size() - 1;
            while (n >= 0) {
                ((File)arrayList.get(n)).mkdir();
                --n;
            }
        }
        if (bl && !file.exists() && !file.mkdir()) {
            if (!this._vhd) {
                throw new NameNotFoundException("Directory does not exist: " + string);
            }
            throw new NamingException("Unable to create directory");
        }
    }

    public Object lookup(String string) throws NamingException {
        File file = this._sp(string);
        try {
            if (!file.exists()) {
                throw new NameNotFoundException(string);
            }
            if (this._hnd && _vid && !file.getCanonicalFile().getPath().endsWith(string.replace('/', File.separatorChar))) {
                throw new NameNotFoundException(string + " (bad casing)");
            }
        }
        catch (IOException iOException) {
            throw new NamingException("IO error: " + iOException.getMessage());
        }
        if (file.isDirectory()) {
            try {
                return this._tld(file.getCanonicalFile());
            }
            catch (IOException iOException) {
                throw new NamingException("IO error: " + iOException.getMessage());
            }
        }
        try {
            return this._pq(file);
        }
        catch (IOException iOException) {
            throw new NamingException("IO Error: " + iOException.getMessage());
        }
    }

    public void rename(String string, String string2) throws NamingException {
        if (string.equals(string2)) {
            return;
        }
        try {
            Object object2;
            this._obe(string2, false);
            File file = this._sp(string);
            File file2 = this._sp(string2);
            if (!file.exists()) {
                throw new NameNotFoundException(file.toString());
            }
            if (file2.exists()) {
                throw new NameAlreadyBoundException(file2.toString());
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                Object var9_9;
                object2 = new FileOutputStream(file2);
                try {
                    IOUtils._bfb(fileInputStream, (OutputStream)object2);
                }
                finally {
                    var9_9 = null;
                    try {
                        ((OutputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
                var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException object2) {}
        }
        catch (IOException iOException) {
            throw new NamingException("IO Error: " + iOException.getMessage());
        }
    }
}

