/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind._ov;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.ObjectUtils;
import com.evermind.xml.XMLUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSourceConfig
extends AbstractDescribable
implements Serializable,
_ov,
Cloneable {
    public static final long serialVersionUID = 67564345L;
    public String connectionDriver;
    public String url;
    public String remoteConnectionDriver;
    public String remoteURL;
    public String sourceLocation;
    public String xaSourceLocation;
    public String className;
    public String username;
    public String password;
    public String description;
    public boolean isDefault;
    public int maxInactivityTimeout;
    public int loginTimeout = -1;
    public int minConnections;
    public int maxConnections;
    public String schemaPath;
    public String host;
    public int port;
    public int staleness;
    public String xaLocation;
    public String pooledLocation;
    public String ejbLocation;
    public boolean implicit;
    public String alivePollQuery;
    public long connectionRetryInterval = 1000L;
    public int maxConnectionAttempts = 3;
    public long waitTimeout = 60000L;
    public Properties properties;

    public void _ap(String string) {
        this.className = string;
    }

    public void _pl(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(string, string2);
    }

    public static int _axd(String string, String string2) throws InstantiationException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InstantiationException("Bad format for " + string + " attribute in data-source: " + string2 + ": " + numberFormatException.getMessage());
        }
    }

    public static long _uhc(String string, String string2) throws InstantiationException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InstantiationException("Bad format for " + string + " attribute in data-source: " + string2 + ": " + numberFormatException.getMessage());
        }
    }

    public String _ytd() {
        return this.sourceLocation;
    }

    public void _xlc(String string) {
        this.sourceLocation = string;
    }

    public void _xrc(int n) {
        this.maxInactivityTimeout = n;
    }

    public int _xqc() {
        return this.maxInactivityTimeout;
    }

    public long _xuc() {
        return this.connectionRetryInterval;
    }

    public void _xvc(long l) {
        this.connectionRetryInterval = l;
    }

    public static double _ode(String string, String string2) throws InstantiationException {
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InstantiationException("Bad format for " + string + " attribute in data-source: " + string2 + ": " + numberFormatException.getMessage());
        }
    }

    public void _yfc(boolean bl) {
        this.isDefault = bl;
    }

    public void _xpc(int n) {
        this.maxConnections = n;
    }

    public int _xoc() {
        return this.maxConnections;
    }

    public Object clone() {
        try {
            DataSourceConfig dataSourceConfig = (DataSourceConfig)super.clone();
            if (this.properties != null) {
                dataSourceConfig.properties = new Properties();
                ((Hashtable)dataSourceConfig.properties).putAll(this.properties);
            }
            return dataSourceConfig;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int _ga() {
        return this.port;
    }

    public void _ybc(int n) {
        this.staleness = n;
    }

    public int _yac() {
        return this.staleness;
    }

    public String _knb() {
        return this.username;
    }

    public void _jhc(String string) {
        this.username = string;
    }

    public boolean _xjc() {
        return this.implicit;
    }

    public Properties _gjc() {
        return this.properties;
    }

    public String _xkc() {
        return this.xaLocation;
    }

    public String _xyc() {
        return this.alivePollQuery;
    }

    public void _xzc(String string) {
        this.alivePollQuery = string;
    }

    public boolean _yec() {
        return this.isDefault;
    }

    public String _hi() {
        return this._ak();
    }

    public void _hm(String string) {
        this._ay(string);
    }

    public String _yyd() {
        return this.remoteConnectionDriver;
    }

    public int _aae() {
        return this.loginTimeout;
    }

    public String _yzd() {
        return this.remoteURL;
    }

    public String _yrd() {
        return this.schemaPath;
    }

    public void _aw(PrintWriter printWriter, String string) {
        printWriter.println(string + "<data-source");
        if (this.className != null) {
            printWriter.println(string + "\tclass=\"" + XMLUtils._bb(this.className) + "\"");
        }
        if (this._ch() != null) {
            printWriter.println(string + "\tname=\"" + XMLUtils._bb(this._ch()) + "\"");
        }
        if (this._hi() != null) {
            printWriter.println(string + "\tlocation=\"" + XMLUtils._bb(this._hi()) + "\"");
        }
        if (this._ycc() != null) {
            printWriter.println(string + "\tpooled-location=\"" + XMLUtils._bb(this._ycc()) + "\"");
        }
        if (this._xkc() != null) {
            printWriter.println(string + "\txa-location=\"" + XMLUtils._bb(this._xkc()) + "\"");
        }
        if (this._ydc() != null) {
            printWriter.println(string + "\tejb-location=\"" + XMLUtils._bb(this._ydc()) + "\"");
        }
        if (this.sourceLocation != null) {
            printWriter.println(string + "\tsource-location=\"" + XMLUtils._bb(this.sourceLocation) + "\"");
        }
        if (this.xaSourceLocation != null) {
            printWriter.println(string + "\txa-source-location=\"" + XMLUtils._bb(this.xaSourceLocation) + "\"");
        }
        if (this.connectionDriver != null) {
            printWriter.println(string + "\tconnection-driver=\"" + XMLUtils._bb(this.connectionDriver) + "\"");
        }
        if (this.username != null) {
            printWriter.println(string + "\tusername=\"" + XMLUtils._bb(this.username) + "\"");
        }
        if (this.password != null) {
            printWriter.println(string + "\tpassword=\"" + XMLUtils._bb(this.password) + "\"");
        }
        if (this.url != null) {
            printWriter.println(string + "\turl=\"" + XMLUtils._bb(this.url) + "\"");
        }
        if (this.minConnections > 0) {
            printWriter.println(string + "\tmin-connections=\"" + this.minConnections + "\"");
        }
        if (this.maxConnections > 0) {
            printWriter.println(string + "\tmax-connections=\"" + this.maxConnections + "\"");
        }
        if (this.staleness > 0) {
            printWriter.println(string + "\tstaleness=\"" + this.staleness + "\"");
        }
        if (this.waitTimeout != 60000L) {
            printWriter.println(string + "\twait-timeout=\"" + this.waitTimeout / 1000L + "\"");
        }
        if (this.remoteConnectionDriver != null) {
            printWriter.println(string + "\tremote-connection-driver=\"" + XMLUtils._bb(this.remoteConnectionDriver) + "\"");
        }
        if (this.remoteURL != null) {
            printWriter.println(string + "\tremote-url=\"" + XMLUtils._bb(this.remoteURL) + "\"");
        }
        if (this._xqc() > 0) {
            printWriter.println(string + "\tinactivity-timeout=\"" + this._xqc() + "\"");
        }
        if (this.maxConnectionAttempts != 3) {
            printWriter.println(string + "\tmax-connection-attempts=\"" + this.maxConnectionAttempts + "\"");
        }
        if (this.connectionRetryInterval != 1000L) {
            if (this.connectionRetryInterval % 1000L == 0L) {
                printWriter.println(string + "\tconnection-retry-interval=\"" + this.connectionRetryInterval / 1000L + "\"");
            } else {
                printWriter.println(string + "\tconnection-retry-interval=\"" + (double)this.connectionRetryInterval / 1000.0 + "\"");
            }
        }
        if (this.alivePollQuery != null) {
            printWriter.println(string + "\talive-poll-query=\"" + XMLUtils._bb(this.alivePollQuery) + "\"");
        }
        if (this.description != null) {
            printWriter.println(string + ">");
            printWriter.println(string + "\t<description>" + XMLUtils._bb(this.description) + "</description>");
            printWriter.println(string + "</data-source>");
        } else {
            printWriter.println(string + "/>");
        }
    }

    public String _bc() {
        return this.description;
    }

    public void _az(String string) {
        this.description = string;
    }

    public String _ycc() {
        return this.pooledLocation;
    }

    public String _ydc() {
        return this.ejbLocation;
    }

    public void _ygc(String string) {
        this.xaSourceLocation = string;
    }

    public String _ysd() {
        return this.xaSourceLocation;
    }

    public Map _ine() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this._ak() != null) {
            hashMap.put("location", this._ak());
        }
        if (this._ch() != null) {
            hashMap.put("displayName", this._ch());
        }
        if (this._bc() != null) {
            hashMap.put("description", this._bc());
        }
        hashMap.put("connectionDriver", this.connectionDriver);
        hashMap.put("url", this.url);
        hashMap.put("sourceLocation", this.sourceLocation);
        hashMap.put("xaSourceLocation", this.xaSourceLocation);
        hashMap.put("className", this.className);
        hashMap.put("username", this.username);
        hashMap.put("password", this.password);
        hashMap.put("description", this.description);
        hashMap.put("default", this.isDefault ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put("maxInactivityTimeout", ObjectUtils._pt(this.maxInactivityTimeout));
        hashMap.put("loginTimeout", ObjectUtils._pt(this.loginTimeout));
        hashMap.put("maxInactivityTimeout", ObjectUtils._pt(this.maxInactivityTimeout));
        hashMap.put("loginTimeout", ObjectUtils._pt(this.loginTimeout));
        hashMap.put("minConnections", ObjectUtils._pt(this.minConnections));
        hashMap.put("maxConnections", ObjectUtils._pt(this.maxConnections));
        hashMap.put("schemaPath", this.schemaPath);
        hashMap.put("host", this.host);
        hashMap.put("port", ObjectUtils._pt(this.port));
        hashMap.put("xaLocation", this.xaLocation);
        hashMap.put("pooledLocation", this.pooledLocation);
        hashMap.put("ejbLocation", this.ejbLocation);
        hashMap.put("implicit", this.implicit ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put("connectionRetryInterval", new Long(this.connectionRetryInterval));
        hashMap.put("alivePollQuery", this.alivePollQuery);
        hashMap.put("maxConnectionAttempts", ObjectUtils._pt(this.maxConnectionAttempts));
        hashMap.put("waitTimeout", new Long(this.waitTimeout));
        hashMap.put("properties", this.properties);
        hashMap.put("staleness", new Integer(this.staleness));
        return hashMap;
    }

    public DataSourceConfig(Map map) {
        this._ay((String)map.get("location"));
        this.remoteURL = (String)map.get("remoteURL");
        this.remoteConnectionDriver = (String)map.get("remoteConnectionDriver");
        this._cp((String)map.get("displayName"));
        this._az((String)map.get("description"));
        this.connectionDriver = (String)map.get("connectionDriver");
        this.url = (String)map.get("url");
        this.sourceLocation = (String)map.get("sourceLocation");
        this.xaSourceLocation = (String)map.get("xaSourceLocation");
        this.className = (String)map.get("className");
        this.username = (String)map.get("username");
        this.password = (String)map.get("password");
        this.description = (String)map.get("description");
        this.isDefault = Boolean.TRUE.equals(map.get("default"));
        this.loginTimeout = ObjectUtils._op(map.get("loginTimeout"), this.maxInactivityTimeout);
        this.minConnections = ObjectUtils._op(map.get("minConnections"), this.maxInactivityTimeout);
        this.maxConnections = ObjectUtils._op(map.get("maxConnections"), this.maxInactivityTimeout);
        this.host = (String)map.get("host");
        this.port = ObjectUtils._op(map.get("port"), this.port);
        this.staleness = ObjectUtils._op(map.get("staleness"), 0);
        this.schemaPath = (String)map.get("schemaPath");
        this.xaLocation = (String)map.get("xaLocation");
        this.pooledLocation = (String)map.get("pooledLocation");
        this.ejbLocation = (String)map.get("ejbLocation");
        this.alivePollQuery = (String)map.get("alivePollQuery");
        this.implicit = Boolean.TRUE.equals(map.get("implicit"));
        this.connectionRetryInterval = ObjectUtils._pn(map.get("connectionRetryInterval"), this.connectionRetryInterval);
        this.maxConnectionAttempts = ObjectUtils._op(map.get("maxConnectionAttempts"), this.maxConnectionAttempts);
        this.waitTimeout = ObjectUtils._pn(map.get("waitTimeout"), this.waitTimeout);
        this.properties = (Properties)map.get("properties");
    }

    public DataSourceConfig(boolean bl) {
        this.implicit = bl;
    }

    public DataSourceConfig(Node node) throws InstantiationException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node2 = namedNodeMap.item(n);
                this._ofe(node2.getNodeName(), node2.getNodeValue());
                ++n;
            }
        }
        if (this.className == null) {
            throw new InstantiationException("No 'class' attribute specified for <data-source> tag");
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node3 = nodeList.item(n2);
            String string = node3.getNodeName();
            if (!XMLUtils._tsb(string)) {
                if (string.equals("source-location")) {
                    this._xlc(XMLUtils.getStringValue(node3));
                } else if (string.equals("class-name")) {
                    this._ap(XMLUtils.getStringValue(node3));
                } else if (string.equals("description")) {
                    this._az(XMLUtils.getStringValue(node3));
                } else if (string.equals("property")) {
                    String string2 = XMLUtils._mj(node3, "name");
                    String string3 = XMLUtils._mj(node3, "value");
                    if (string2 == null) {
                        throw new InstantiationException("data-source tag with missing name attribute");
                    }
                    if (string3 == null) {
                        throw new InstantiationException("data-source tag with missing value attribute");
                    }
                    this._pl(string2, string3);
                } else if (string.equals("connection-driver")) {
                    this._oee(XMLUtils.getStringValue(node3));
                } else if (string.equals("name")) {
                    this._cp(XMLUtils.getStringValue(node3));
                } else if (string.equals("username")) {
                    this._jhc(XMLUtils.getStringValue(node3));
                } else if (string.equals("password")) {
                    this._ywd(XMLUtils.getStringValue(node3));
                } else if (string.equals("url")) {
                    this._me(XMLUtils.getStringValue(node3));
                } else if (string.equals("inactivity-timeout")) {
                    try {
                        this._xrc(Integer.parseInt(XMLUtils.getStringValue(node3)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("max-connections")) {
                    try {
                        this._xpc(Integer.parseInt(XMLUtils.getStringValue(node3)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("url")) {
                    this._me(XMLUtils.getStringValue(node3));
                } else if (string.equals("default")) {
                    this._yfc(true);
                } else {
                    throw new InstantiationException("Unknown data-source subtag: '" + string + "'");
                }
            }
            ++n2;
        }
        if (this.className != null && this.className.equals("com.evermind.sql.ConnectionDataSource")) {
            this.className = "com.evermind.sql.DriverManagerDataSource";
        } else if (this.className != null && this.className.equals("com.evermind.sql.DefaultXADataSource")) {
            this.className = "com.evermind.sql.DriverManagerXADataSource";
        }
    }

    public String _tid() {
        return this.password;
    }

    public String _yxd() {
        return this.connectionDriver;
    }

    public void _oee(String string) {
        this.connectionDriver = string;
    }

    public void _ywd(String string) {
        this.password = string;
    }

    public String _xa() {
        return this.host;
    }

    public long _xwc() {
        return this.waitTimeout;
    }

    public void _xxc(long l) {
        this.waitTimeout = l;
    }

    public String _mf() {
        return this.url;
    }

    public void _me(String string) {
        this.url = string;
    }

    public void _xnc(int n) {
        this.maxConnections = n;
    }

    public int _xmc() {
        return this.minConnections;
    }

    public int _xsc() {
        return this.maxConnectionAttempts;
    }

    public void _xtc(int n) {
        this.maxConnectionAttempts = n;
    }

    public void _ofe(String string, String string2) throws InstantiationException {
        if (string.equals("class")) {
            this._ap(string2);
        } else if (string.equals("location")) {
            this._hm(string2);
            this._ay(string2);
        } else if (string.equals("username")) {
            this.username = string2;
        } else if (string.equals("password")) {
            this.password = string2;
        } else if (string.equals("url")) {
            this.url = string2;
        } else if (string.equals("connection-driver")) {
            this.connectionDriver = string2;
        } else if (string.equals("xa-location")) {
            this.xaLocation = string2;
        } else if (string.equals("pooled-location")) {
            this.pooledLocation = string2;
        } else if (string.equals("ejb-location")) {
            this.ejbLocation = string2;
        } else if (string.equals("schema")) {
            this.schemaPath = string2;
        } else if (string.equals("source-location")) {
            this.sourceLocation = string2;
        } else if (string.equals("xa-source-location")) {
            this.xaSourceLocation = string2;
        } else if (string.equals("name")) {
            this._cp(string2);
        } else if (string.equals("host")) {
            this.host = string2;
        } else if (string.equals("wait-timeout")) {
            this.waitTimeout = DataSourceConfig._uhc("wait-timeout", string2) * 1000L;
        } else if (string.equals("inactivity-timeout")) {
            this.maxInactivityTimeout = DataSourceConfig._axd("inactivity-timeout", string2);
        } else if (string.equals("min-connections")) {
            this.minConnections = DataSourceConfig._axd("min-connections", string2);
        } else if (string.equals("max-connections")) {
            this.maxConnections = DataSourceConfig._axd("max-connections", string2);
        } else if (string.equals("login-timeout")) {
            this.maxConnections = DataSourceConfig._axd("max-connections", string2);
        } else if (string.equals("max-connection-attempts")) {
            this.maxConnectionAttempts = DataSourceConfig._axd("max-connection-attempts", string2);
        } else if (string.equals("connection-retry-interval")) {
            this.connectionRetryInterval = (long)(DataSourceConfig._ode("connection-retry-interval", string2) * 1000.0);
        } else if (string.equals("port")) {
            this.port = DataSourceConfig._axd("port", string2);
        } else if (string.equals("remote-connection-driver")) {
            this.remoteConnectionDriver = string2;
        } else if (string.equals("remote-url")) {
            this.remoteURL = string2;
        } else if (string.equals("staleness-timeout")) {
            this.staleness = DataSourceConfig._axd("staleness-timeout", string2);
        } else if (string.equals("alive-poll-query")) {
            this.alivePollQuery = string2;
        } else {
            throw new InstantiationException("Unknown data-source attribute: '" + string + "'");
        }
    }

    public String _ax() {
        return this.className;
    }
}

