/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind._hnb;
import com.evermind._hvb;
import com.evermind._ts;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.AdministrationPermission;
import com.evermind.server.rmi.RMIPermission;
import com.evermind.xml.XMLConfig;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUserManager
extends XMLConfig
implements UserManager {
    public UserManager _go;
    public Map _hqb = new HashMap();
    public Map _hpb = new HashMap();
    public User _vmd;

    public List getUsers(int n, int n2) {
        Map map = this._hpb;
        synchronized (map) {
            ArrayList arrayList = new ArrayList(this._hpb.values());
            Collections.sort(arrayList);
            List list = arrayList.subList(n, n2);
            Object var5_6 = null;
            return list;
        }
    }

    public void _wi(Node node) throws InstantiationException {
        String string = node.getNodeName();
        if (string.equals("users")) {
            this._one(node);
        } else if (string.equals("groups")) {
            this._ooe(node);
        } else {
            super._wi(node);
        }
    }

    protected void _ole(Node node) throws InstantiationException {
        _hvb _hvb2 = new _hvb(node, this);
        if (this._hpb.containsKey(_hvb2.getName())) {
            throw new InstantiationException("Duplicate user: " + _hvb2.getName() + " in " + this._mf());
        }
        this._hpb.put(_hvb2.getName(), _hvb2);
    }

    protected void _ome(Node node) throws InstantiationException {
        _hnb _hnb2 = new _hnb(XMLUtils._mj(node, "name"));
        if (_hnb2.getName() == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (string.equals("description")) {
                _hnb2.setDescription(XMLUtils.getStringValue(node2));
            } else if (string.equals("permission")) {
                String string2 = XMLUtils._mj(node2, "name");
                if (string2 == null) {
                    string2 = XMLUtils.getStringValue(node2);
                }
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("administration")) {
                        _hnb2.addPermission(AdministrationPermission.INSTANCE);
                    } else if (string2.equalsIgnoreCase("rmi:login")) {
                        _hnb2.addPermission(new RMIPermission("login"));
                    } else {
                        try {
                            Permission permission = (Permission)_ts._qu(string2, this.getClass().getClassLoader());
                            if (permission != null) {
                                _hnb2.addPermission(permission);
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++n;
        }
        if (this._hqb.containsKey(_hnb2.getName())) {
            throw new InstantiationException("Duplicate group: " + _hnb2.getName() + " in " + this._mf());
        }
        if ("true".equalsIgnoreCase(XMLUtils._mj(node, "default"))) {
            this.addDefaultGroup(_hnb2.getName());
            _hnb2._yfc(true);
        }
        this._hqb.put(_hnb2.getName(), _hnb2);
    }

    public User getUser(String string) {
        if (this._hpb != null) {
            Map map = this._hpb;
            synchronized (map) {
                block5: {
                    _hvb _hvb2 = (_hvb)this._hpb.get(string);
                    if (_hvb2 == null) break block5;
                    _hvb _hvb3 = _hvb2;
                    Object var4_5 = null;
                    return _hvb3;
                }
                Object var4_6 = null;
            }
        }
        if (this._go != null) {
            return this._go.getUser(string);
        }
        return null;
    }

    public User getUser(String string, BigInteger bigInteger) {
        if (this._hpb != null) {
            Map map = this._hpb;
            synchronized (map) {
                Iterator iterator = this._hpb.values().iterator();
                while (iterator.hasNext()) {
                    _hvb _hvb2 = (_hvb)iterator.next();
                    BigInteger bigInteger2 = _hvb2.getCertificateSerial();
                    if (bigInteger2 == null || !bigInteger2.equals(bigInteger) || !string.equals(_hvb2.getCertificateIssuerDN())) continue;
                    _hvb _hvb3 = _hvb2;
                    Object var7_8 = null;
                    return _hvb3;
                }
                Object var7_9 = null;
            }
        }
        if (this._go != null) {
            return this._go.getUser(string, bigInteger);
        }
        return null;
    }

    public User getUser(X509Certificate x509Certificate) {
        return this.getUser(x509Certificate.getIssuerDN().getName(), x509Certificate.getSerialNumber());
    }

    public void _wj(String string) throws InstantiationException {
        if (!string.equals("principals")) {
            throw new InstantiationException(this._ak() + " contained a " + string + " file, not a principals file as expected");
        }
    }

    public void addDefaultGroup(String string) {
    }

    public User getAnonymousUser() {
        if (this._vmd == null) {
            if (this._go != null) {
                this._vmd = this._go.getAnonymousUser();
            } else {
                _hvb _hvb2 = new _hvb(this, "guest");
                _hvb2._ckd(true);
                this._vmd = _hvb2;
                if (this._hpb != null) {
                    this._hpb.put("guest", this._vmd);
                }
            }
        }
        return this._vmd;
    }

    public User createUser(String string, String string2) {
        if (this.getUser(string) != null) {
            throw new IllegalArgumentException("User '" + string + "' already exists");
        }
        _hvb _hvb2 = new _hvb(this, string, string2);
        Map map = this._hpb;
        synchronized (map) {
            this._hpb.put(string, _hvb2);
            Object var5_5 = null;
        }
        return _hvb2;
    }

    public Group getGroup(String string) {
        if (this._hqb != null) {
            Map map = this._hqb;
            synchronized (map) {
                block5: {
                    Group group = (Group)this._hqb.get(string);
                    if (group == null) break block5;
                    Group group2 = group;
                    Object var4_5 = null;
                    return group2;
                }
                Object var4_6 = null;
            }
        }
        if (this._go != null) {
            return this._go.getGroup(string);
        }
        return null;
    }

    public synchronized void _bu(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<!DOCTYPE principals PUBLIC \"//Evermind - Orion Principals//\" \"http://www.orionserver.com/dtds/principals.dtd\">");
        printWriter.println();
        this._aw(printWriter, "");
    }

    protected void _one(Node node) throws InstantiationException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (string.equals("user")) {
                this._ole(node2);
            }
            ++n;
        }
    }

    protected void _ooe(Node node) throws InstantiationException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (string.equals("group")) {
                this._ome(node2);
            }
            ++n;
        }
    }

    public void _aw(PrintWriter printWriter, String string) throws IOException {
        printWriter.println(string + "<principals>");
        printWriter.println(string + "\t<groups>");
        if (this._hqb != null) {
            XMLUtils._bd(this._hqb.values(), printWriter, string + "\t\t");
        }
        printWriter.println(string + "\t</groups>");
        printWriter.println(string + "\t<users>");
        if (this._hpb != null) {
            XMLUtils._bd(this._hpb.values(), printWriter, string + "\t\t");
        }
        printWriter.println(string + "\t</users>");
        printWriter.println(string + "</principals>");
    }

    public boolean remove(Group group) {
        return this._hqb.remove(group.getName()) != null;
    }

    public boolean remove(User user) {
        Map map = this._hpb;
        synchronized (map) {
            this._hpb.remove(user.getName());
            Object var3_3 = null;
        }
        return true;
    }

    public User getAdminUser() {
        if (this._hpb != null) {
            Map map = this._hpb;
            synchronized (map) {
                Iterator iterator = this._hpb.values().iterator();
                while (iterator.hasNext()) {
                    _hvb _hvb2 = (_hvb)iterator.next();
                    if (!_hvb2.hasPermission(AdministrationPermission.INSTANCE)) continue;
                    _hvb _hvb3 = _hvb2;
                    Object var4_5 = null;
                    return _hvb3;
                }
                Object var4_6 = null;
            }
        }
        return null;
    }

    public Group createGroup(String string) throws InstantiationException {
        Map map = this._hqb;
        synchronized (map) {
            if (this.getGroup(string) != null) {
                throw new IllegalArgumentException("group " + string + " already exists");
            }
            _hnb _hnb2 = new _hnb(string);
            this._hqb.put(string, _hnb2);
            _hnb _hnb3 = _hnb2;
            Object var4_5 = null;
            return _hnb3;
        }
    }

    public int getUserCount() {
        Map map = this._hpb;
        synchronized (map) {
            int n = this._hpb.size();
            Object var2_3 = null;
            return n;
        }
    }

    public int getGroupCount() {
        Map map = this._hqb;
        synchronized (map) {
            int n = this._hqb.size();
            Object var2_3 = null;
            return n;
        }
    }

    public void _azb() {
        this._hqb.clear();
        this._hpb.clear();
    }

    public void setParent(UserManager userManager) {
        this._go = userManager;
    }

    public UserManager getParent() {
        return this._go;
    }

    public XMLUserManager() {
        super(null);
    }

    public String _ncb() {
        return "META-INF/principals.dtd";
    }

    public void init(Properties properties) throws InstantiationException {
        String string = properties.getProperty("path");
        if (string == null) {
            throw new InstantiationException("Missing 'path' property, required for XMLUserManager");
        }
        try {
            this._dj(new File(string).toURL());
        }
        catch (IOException iOException) {
            throw new InstantiationException("Error reading configuration '" + string + "': " + iOException.getMessage());
        }
    }

    public List getGroups(int n, int n2) {
        Map map = this._hqb;
        synchronized (map) {
            ArrayList arrayList = new ArrayList(this._hqb.values());
            Collections.sort(arrayList);
            List list = arrayList.subList(n, n2);
            Object var5_6 = null;
            return list;
        }
    }

    public Set getDefaultGroups() {
        return Collections.EMPTY_SET;
    }
}

