/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind._ov;
import com.evermind._vh;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import javax.jms.Queue;
import org.w3c.dom.Node;

public class EvermindQueue
extends EvermindDestination
implements Queue,
Serializable,
_ov {
    public static final long serialVersionUID = 75984496537616676L;
    public String name;
    public String location;
    public String description;
    public transient String _ane;
    public transient String _aoe;
    public transient int _wpb = 2;

    public String toString() {
        return "[Queue " + this.name + "]";
    }

    public EvermindQueue(String string) {
        this.name = string;
    }

    public EvermindQueue(Node node, URL uRL) throws InstantiationException {
        this.name = XMLUtils._mj(node, "name");
        this.location = XMLUtils._mj(node, "location");
        this.description = XMLUtils._fqc(node, "description");
        String string = XMLUtils._mj(node, "persistence-type");
        if (string != null) {
            this._gz(string);
        }
        this._ane = XMLUtils._mj(node, "persistence-file");
        if (this._ane != null && uRL != null) {
            try {
                this._aoe = _vh._mf(uRL, this._ane).getFile();
            }
            catch (IOException iOException) {
                throw new InstantiationException("Invalid persistence-file URL: " + iOException.getMessage());
            }
        }
        if (this.name == null) {
            throw new InstantiationException("queue tag with missing name attribute");
        }
    }

    public String _che() {
        return this._aoe;
    }

    public void _gz(String string) throws InstantiationException {
        if (string.equals("instant")) {
            this._wpb = 2;
        } else if (string.equals("shutdown")) {
            this._wpb = 1;
        } else if (string.equals("instant-all")) {
            this._wpb = 3;
        } else if (string.equals("none")) {
            this._wpb = 4;
        } else {
            throw new InstantiationException("Invalid persistence-type: '" + string + "'");
        }
    }

    public String getQueueName() {
        return this.name;
    }

    public static String _qbe(int n) {
        switch (n) {
            case 2: {
                return "instant";
            }
            case 3: {
                return "instant-all";
            }
            case 1: {
                return "shutdown";
            }
            case 4: {
                return "none";
            }
        }
        throw new InternalError("Unknown persistence-type: " + n);
    }

    public String _ak() {
        return this.name;
    }

    public int _hq() {
        return 1;
    }

    public void _aw(PrintWriter printWriter, String string) {
        printWriter.print(string + "<queue");
        if (this.location != null) {
            printWriter.print(" location=\"" + XMLUtils._bb(this.location) + "\"");
        }
        if (this.name != null) {
            printWriter.print(" name=\"" + XMLUtils._bb(this.name) + "\"");
        }
        if (this._ane != null) {
            printWriter.print(" persistence-file=\"" + XMLUtils._bb(this._ane) + "\"");
        }
        if (this._wpb != 2) {
            printWriter.print(" persistence-type=\"" + XMLUtils._bb(EvermindQueue._qbe(this._wpb) + "\""));
        }
        if (this.description != null) {
            printWriter.println(">");
            printWriter.println(string + "\t<description>" + XMLUtils._bb(this.description) + "</description>");
            printWriter.println(string + "</queue>");
        } else {
            printWriter.println(" />");
        }
    }

    public String _hi() {
        return this.location;
    }
}

