/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.sql;

import com.evermind._ks;
import com.evermind._pu;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;

public class DriverManagerDataSource
implements DataSource,
Serializable {
    public static final boolean DEBUG = _pu._dn("jdbc.debug", false);
    private String name;
    public String url;
    public transient Driver _eqc;
    public Properties driverProperties;
    public transient boolean _erc;
    public String driverName;
    public String username;
    public String password;
    public transient PrintWriter _ebc;
    public int loginTimeout;
    public boolean defaultAutoCommit = true;
    public String location;
    public String remoteDriverName;
    public String remoteURL;
    public transient boolean _esc = true;

    public String _hi() {
        return this.location;
    }

    public void _cld(Driver driver) {
        this._eqc = driver;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public String toString() {
        return this.url;
    }

    public void setLogin(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    public void _cmd(String string) {
        this.remoteURL = string;
    }

    public void setURL(String string) {
        this.url = string;
        if (this._ebc != null) {
            this._ebc.println(this + ": Started");
        }
    }

    public Connection getConnection() throws SQLException {
        if (this._ebc != null) {
            this._ebc.println(this + ": Opened connection");
        }
        if (this._eqc != null) {
            Connection connection;
            if (this.driverProperties == null) {
                this.driverProperties = new Properties();
                if (this.username != null) {
                    ((Hashtable)this.driverProperties).put("user", this.username);
                }
                if (this.password != null) {
                    ((Hashtable)this.driverProperties).put("password", this.password);
                }
            }
            if ((connection = this._eqc.connect(this.url, this.driverProperties)) == null) {
                throw new SQLException("The database driver (" + this._eqc + ") returned refusing to connect to the URL " + this.url);
            }
            if (DEBUG) {
                connection = new _ks(connection, true);
            }
            return connection;
        }
        if (!this._erc && this.driverName != null) {
            if (!this._esc) {
                if (this.remoteDriverName != null) {
                    this.driverName = this.remoteDriverName;
                }
                if (this.remoteURL != null) {
                    this.url = this.remoteURL;
                }
            }
            try {
                this._cnd(this.driverName, Thread.currentThread().getContextClassLoader());
                return this.getConnection(this.username, this.password);
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Error loading driver '" + this.driverName + "': " + instantiationException.getMessage());
            }
        }
        if (this.username == null || this.password == null) {
            Connection connection = DriverManager.getConnection(this.url);
            if (DEBUG) {
                connection = new _ks(connection, true);
            }
            return connection;
        }
        Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
        if (DEBUG) {
            connection = new _ks(connection, true);
        }
        return connection;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this._ebc != null) {
            this._ebc.println(this + ": Opened connection");
        }
        if (this._eqc != null) {
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", string);
            ((Hashtable)properties).put("password", string2);
            Connection connection = this._eqc.connect(this.url, properties);
            if (!this.defaultAutoCommit) {
                connection.setAutoCommit(false);
            }
            if (DEBUG) {
                connection = new _ks(connection, this.defaultAutoCommit);
            }
            return connection;
        }
        if (!this._erc && this.driverName != null) {
            if (!this._esc) {
                if (this.remoteDriverName != null) {
                    this.driverName = this.remoteDriverName;
                }
                if (this.remoteURL != null) {
                    this.url = this.remoteURL;
                }
            }
            try {
                this._cnd(this.driverName, Thread.currentThread().getContextClassLoader());
                return this.getConnection(string, string2);
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Error loading driver '" + this.driverName + "': " + instantiationException.getMessage());
            }
        }
        Connection connection = DriverManager.getConnection(this.url, string, string2);
        if (!this.defaultAutoCommit) {
            connection.setAutoCommit(false);
        }
        if (DEBUG) {
            connection = new _ks(connection, !this.defaultAutoCommit);
        }
        return connection;
    }

    public PrintWriter getLogWriter() {
        return this._ebc;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._ebc = printWriter;
    }

    public void _cnd(String string, ClassLoader classLoader) throws InstantiationException {
        this._erc = true;
        this.driverName = string;
        try {
            Class.forName(string, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                this._cld((Driver)Class.forName(string, true, classLoader).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new InstantiationException("DriverManagerDataSource driver '" + string + "' not found");
            }
            catch (ClassCastException classCastException) {
                throw new InstantiationException("Class '" + this._eqc + "' is not a java.sql.Driver");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InstantiationException("Error instantiating '" + this._eqc + "' access exception: " + illegalAccessException.getMessage());
            }
        }
    }

    public void _cod(String string) {
        this.remoteDriverName = string;
    }

    public void _hm(String string) {
        this.location = string;
    }
}

