/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private String allow;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getProtocol().endsWith("1.1")) {
            response.sendError(405, "HTTP method POST is not supported by this URL");
        } else {
            response.sendError(400, "HTTP method POST is not supported by this URL");
        }
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String CRLF = "\r\n";
        String responseString = "TRACE " + request.getRequestURI() + ' ' + request.getProtocol();
        Enumeration reqHeaderEnum = request.getHeaderNames();
        while (reqHeaderEnum.hasMoreElements()) {
            String headerName = (String)reqHeaderEnum.nextElement();
            responseString = responseString + CRLF + headerName + ": " + request.getHeader(headerName);
        }
        responseString = responseString + CRLF;
        int responseLength = responseString.length();
        response.setContentType("message/http");
        response.setContentLength(responseLength);
        ServletOutputStream out = response.getOutputStream();
        out.print(responseString);
        out.close();
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getProtocol().endsWith("1.1")) {
            response.sendError(405, "HTTP method DELETE is not supported by this URL");
        } else {
            response.sendError(400, "HTTP method DELETE is not supported by this URL");
        }
    }

    private void maybeSetLastModified(HttpServletResponse response, long lastModified) {
        if (response.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (lastModified >= 0L) {
            response.setDateHeader(HEADER_LASTMOD, lastModified);
        }
    }

    protected synchronized void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.allow == null) {
            Method[] methods = this.getAllDeclaredMethods(this.getClass());
            boolean ALLOW_GET = false;
            boolean ALLOW_HEAD = false;
            boolean ALLOW_POST = false;
            boolean ALLOW_PUT = false;
            boolean ALLOW_DELETE = false;
            boolean ALLOW_TRACE = true;
            boolean ALLOW_OPTIONS = true;
            int i = 0;
            while (i < methods.length) {
                Method m = methods[i];
                if (m.getName().equals("doGet")) {
                    ALLOW_GET = true;
                    ALLOW_HEAD = true;
                }
                if (m.getName().equals("doPost")) {
                    ALLOW_POST = true;
                }
                if (m.getName().equals("doPut")) {
                    ALLOW_PUT = true;
                }
                if (m.getName().equals("doDelete")) {
                    ALLOW_DELETE = true;
                }
                ++i;
            }
            if (ALLOW_GET && this.allow == null) {
                this.allow = METHOD_GET;
            }
            if (ALLOW_HEAD) {
                this.allow = this.allow == null ? METHOD_HEAD : this.allow + ", " + METHOD_HEAD;
            }
            if (ALLOW_POST) {
                this.allow = this.allow == null ? METHOD_POST : this.allow + ", " + METHOD_POST;
            }
            if (ALLOW_PUT) {
                this.allow = this.allow == null ? METHOD_PUT : this.allow + ", " + METHOD_PUT;
            }
            if (ALLOW_DELETE) {
                this.allow = this.allow == null ? METHOD_DELETE : this.allow + ", " + METHOD_DELETE;
            }
            if (ALLOW_TRACE) {
                this.allow = this.allow == null ? METHOD_TRACE : this.allow + ", " + METHOD_TRACE;
            }
            if (ALLOW_OPTIONS) {
                this.allow = this.allow == null ? METHOD_OPTIONS : this.allow + ", " + METHOD_OPTIONS;
            }
        }
        response.setHeader("Allow", this.allow);
    }

    protected long getLastModified(HttpServletRequest request) {
        return -1L;
    }

    protected void service(EvermindHttpServletRequest request, EvermindHttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        if (method == METHOD_GET) {
            long lastModified = this.getLastModified(request);
            if (lastModified == -1L) {
                this.doGet(request, response);
            } else {
                this.maybeSetLastModified(response, lastModified);
                if (request.isNeeded(lastModified)) {
                    this.doGet(request, response);
                } else {
                    response.sendError(304);
                }
            }
        } else if (method == METHOD_HEAD) {
            long lastModified = this.getLastModified(request);
            this.maybeSetLastModified(response, lastModified);
            this.doHead(request, response);
        } else if (method == METHOD_POST) {
            this.doPost(request, response);
        } else if (method == METHOD_PUT) {
            this.doPut(request, response);
        } else if (method == METHOD_DELETE) {
            this.doDelete(request, response);
        } else if (method == METHOD_OPTIONS) {
            this.doOptions(request, response);
        } else if (method == METHOD_TRACE) {
            this.doTrace(request, response);
        } else {
            String errorMessage = "Method " + method + " is not defined in RFC 2068 and is not supported by the Servlet API";
            response.sendError(501, errorMessage);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EvermindHttpServletRequest specificRequest = null;
        EvermindHttpServletResponse specificResponse = null;
        try {
            specificRequest = (EvermindHttpServletRequest)request;
            specificResponse = (EvermindHttpServletResponse)response;
        }
        catch (ClassCastException e) {
            String method = request.getMethod();
            if (method.equals(METHOD_GET)) {
                long lastModified = this.getLastModified(request);
                if (lastModified == -1L) {
                    this.doGet(request, response);
                } else {
                    long ifModifiedSince = request.getDateHeader(HEADER_IFMODSINCE);
                    if (ifModifiedSince == -1L) {
                        this.doGet(request, response);
                    } else {
                        this.maybeSetLastModified(response, lastModified);
                        long now = System.currentTimeMillis();
                        if (now < ifModifiedSince || ifModifiedSince < lastModified) {
                            this.doGet(request, response);
                        } else {
                            response.sendError(304);
                        }
                    }
                }
            } else if (method.equals(METHOD_HEAD)) {
                long lastModified = this.getLastModified(request);
                this.maybeSetLastModified(response, lastModified);
                this.doGet(request, response);
            } else if (method.equals(METHOD_POST)) {
                this.doPost(request, response);
            } else if (method.equals(METHOD_PUT)) {
                this.doPut(request, response);
            } else if (method.equals(METHOD_DELETE)) {
                this.doDelete(request, response);
            } else if (method.equals(METHOD_OPTIONS)) {
                this.doOptions(request, response);
            } else if (method.equals(METHOD_TRACE)) {
                this.doTrace(request, response);
            } else {
                String errorMessage = "Method " + method + " is not defined in RFC 2068 and is not supported by the Servlet API";
                response.sendError(501, errorMessage);
            }
            return;
        }
        this.service(specificRequest, specificResponse);
    }

    public void service(ServletRequest genericRequest, ServletResponse genericResponse) throws ServletException, IOException {
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        try {
            request = (HttpServletRequest)genericRequest;
            response = (HttpServletResponse)genericResponse;
        }
        catch (ClassCastException cce) {
            throw new ServletException("non-HTTP request or response");
        }
        this.service(request, response);
    }

    private Method[] getAllDeclaredMethods(Class c) {
        if (c.getName().equals("javax.servlet.http.HttpServlet")) {
            return null;
        }
        int j = 0;
        Method[] parentMethods = this.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (parentMethods != null) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            int i = 0;
            while (i < parentMethods.length) {
                allMethods[i] = parentMethods[i];
                j = i++;
            }
            i = ++j;
            while (i < thisMethods.length + j) {
                allMethods[i] = thisMethods[i - j];
                ++i;
            }
            return allMethods;
        }
        return thisMethods;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getProtocol().endsWith("1.1")) {
            response.sendError(405, "HTTP method GET is not supported by this URL");
        } else {
            response.sendError(400, "HTTP method GET is not supported by this URL");
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getProtocol().endsWith("1.1")) {
            response.sendError(405, "HTTP method PUT is not supported by this URL");
        } else {
            response.sendError(400, "HTTP method PUT is not supported by this URL");
        }
    }
}

