/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.tagext;

import com.evermind.server.http.TagLibraryArchive;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class TagLibraryInfo
implements EntityResolver {
    protected String prefix;
    protected String shortname;
    protected String uri;
    protected String jspversion = "1.2";
    protected String tlibversion;
    protected String urn;
    protected String info;
    private TagLibraryValidator validator;
    private String[] listeners;
    private Map tagMap;
    protected TagInfo[] tags;

    public String getShortName() {
        return this.shortname;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse() throws SAXException, IOException, InstantiationException {
        InputStream tldis = null;
        try {
            InputSource source;
            if (this instanceof TagLibraryArchive) {
                tldis = TagLibraryArchive.currentIn;
                source = new InputSource(tldis);
            } else {
                source = new InputSource(this.urn);
            }
            source.setSystemId(System.getProperty("user.dir"));
            Document document = XMLUtils.getDocument(source, null, this, false);
            if (document == null) {
                throw new IllegalArgumentException("Error parsing tag-library " + this.uri + ", empty document");
            }
            Element element = document.getDocumentElement();
            if (element == null) {
                throw new IllegalArgumentException("Error parsing tag-library " + this.uri + ", empty document");
            }
            if (!element.getNodeName().equals("taglib")) {
                throw new IllegalArgumentException("Error parsing tag-library " + this.uri + ", the TLD was not of type taglib");
            }
            NodeList nodes = element.getChildNodes();
            if (nodes != null) {
                int i = 0;
                while (i < nodes.getLength()) {
                    this.parseMainNode(nodes.item(i));
                    ++i;
                }
            }
            if (this.urn == null) {
                this.urn = this.uri.toString();
            }
            if (this.shortname == null) {
                throw new IllegalArgumentException("shortname not specified in TLD");
            }
            Object var8_7 = null;
            if (tldis == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (tldis == null) throw throwable;
            tldis.close();
            throw throwable;
        }
        tldis.close();
    }

    protected TagInfo parseTag(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        String tagName = null;
        String tagclass = null;
        String teiClassName = null;
        String bodycontent = null;
        String info = null;
        ArrayList<TagAttributeInfo> attributes = null;
        String id = null;
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("name")) {
                    tagName = XMLUtils.getStringValue(node);
                } else if (name.equals("tagclass")) {
                    tagclass = XMLUtils.getStringValue(node);
                } else if (name.equals("teiclass")) {
                    teiClassName = XMLUtils.getStringValue(node);
                } else if (name.equals("bodycontent")) {
                    bodycontent = XMLUtils.getStringValue(node);
                } else if (name.equals("info")) {
                    info = XMLUtils.getStringValue(node);
                } else if (name.equals("id")) {
                    id = XMLUtils.getStringValue(node);
                } else if (name.equals("attribute")) {
                    if (attributes == null) {
                        attributes = new ArrayList<TagAttributeInfo>();
                    }
                    attributes.add(TagLibraryInfo.parseAttribute(node));
                }
                ++i;
            }
        }
        TagAttributeInfo[] attributeInfo = attributes == null ? null : attributes.toArray(new TagAttributeInfo[attributes.size()]);
        TagExtraInfo extraInfo = null;
        if (teiClassName != null) {
            try {
                Class<?> teiClass = Class.forName(teiClassName, true, Thread.currentThread().getContextClassLoader());
                extraInfo = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class " + teiClassName + " not found");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Class " + teiClassName + " wasnt an instance of a TagExtraInfo");
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to instantiate " + teiClassName + ": " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to instantiate " + teiClassName + ": " + e.getMessage());
            }
        }
        if (tagclass == null) {
            throw new InstantiationException("Missing 'tagclass' in tag definition");
        }
        return new TagInfo(tagName, tagclass, bodycontent, info, this, extraInfo, attributeInfo);
    }

    protected TagLibraryInfo(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
        try {
            this.parse();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instantiating XML parser: " + e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error parsing tag-library " + uri + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading tag-library " + uri + ": " + e.getMessage());
        }
    }

    public TagInfo getTag(String shortname) {
        if (this.tagMap == null) {
            return null;
        }
        return (TagInfo)this.tagMap.get(shortname);
    }

    public InputSource resolveEntity(String a, String b) {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("META-INF/web-jsptaglibrary_1_1.dtd");
        if (in != null) {
            return new InputSource(in);
        }
        return null;
    }

    protected void parseMainNode(Node node) throws InstantiationException {
        String validatorClassName;
        String name = node.getNodeName();
        if (name.equals("tlibversion")) {
            this.tlibversion = XMLUtils.getStringValue(node);
        } else if (name.equals("jspversion")) {
            this.jspversion = XMLUtils.getStringValue(node);
        } else if (name.equals("shortname")) {
            this.shortname = XMLUtils.getStringValue(node);
        } else if (name.equals("uri")) {
            this.urn = XMLUtils.getStringValue(node);
        } else if (name.equals("info")) {
            this.info = XMLUtils.getStringValue(node);
        } else if (name.equals("tag")) {
            this.addTag(this.parseTag(node));
        } else if (name.equals("validatorclass") && (validatorClassName = XMLUtils.getStringValue(node)) != null) {
            try {
                Class<?> validatorClass = Class.forName(validatorClassName, true, Thread.currentThread().getContextClassLoader());
                this.validator = (TagLibraryValidator)validatorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class " + validatorClassName + " not found");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Class " + validatorClassName + " wasnt an instance of a TagLibraryValidator");
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to instantiate " + validatorClassName + ": " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to instantiate " + validatorClassName + ": " + e.getMessage());
            }
        }
    }

    public String getReliableURN() {
        if (this.urn == null) {
            return this.uri;
        }
        return this.urn;
    }

    public String getURI() {
        return this.uri;
    }

    protected static TagAttributeInfo parseAttribute(Node parent) {
        NodeList list = parent.getChildNodes();
        String attributeName = null;
        boolean required = false;
        boolean rtexprvalue = false;
        String type = null;
        String id = null;
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("name")) {
                    attributeName = XMLUtils.getStringValue(node);
                } else if (name.equals("required")) {
                    required = "yes".equalsIgnoreCase(XMLUtils.getStringValue(node)) || "true".equalsIgnoreCase(XMLUtils.getStringValue(node));
                } else if (name.equals("rtexprvalue")) {
                    rtexprvalue = "yes".equalsIgnoreCase(XMLUtils.getStringValue(node)) || "true".equalsIgnoreCase(XMLUtils.getStringValue(node));
                } else if (name.equals("type")) {
                    type = XMLUtils.getStringValue(node);
                } else if (name.equals("id")) {
                    id = XMLUtils.getStringValue(node);
                }
                ++i;
            }
        }
        return new TagAttributeInfo(attributeName, required, type, rtexprvalue);
    }

    public String getInfoString() {
        return this.info;
    }

    public String getPrefixString() {
        if (this.prefix == null) {
            return this.shortname;
        }
        return this.prefix;
    }

    public void addTag(TagInfo tag) {
        if (this.tagMap == null) {
            this.tagMap = new HashMap();
        }
        this.tagMap.put(tag.getTagName(), tag);
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.validator;
    }

    public TagInfo[] getTags() {
        if (this.tagMap == null) {
            return new TagInfo[0];
        }
        return this.tagMap.values().toArray(new TagInfo[this.tagMap.values().size()]);
    }

    public String getRequiredVersion() {
        return this.jspversion;
    }
}

