/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BigInt;
import com.sun.net.ssl.internal.ssl.BitArray;
import com.sun.net.ssl.internal.ssl.DerInputBuffer;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import com.sun.net.ssl.internal.ssl.t;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class DerInputStream {
    DerInputBuffer a;

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.a = derInputBuffer;
        this.a.mark(Integer.MAX_VALUE);
    }

    public DerInputStream(byte[] byArray) {
        this.a(byArray, 0, byArray.length);
    }

    public DerInputStream(byte[] byArray, int n2, int n3) {
        this.a(byArray, n2, n3);
    }

    public int available() {
        return this.a.available();
    }

    public byte[] getBitString() throws IOException {
        byte[] byArray;
        if (this.a.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int n2 = DerInputStream.a(this.a);
        if (this.a.read() != 0) {
            throw new IOException("unaligned bit string");
        }
        if (this.a.read(byArray = new byte[--n2]) != n2) {
            throw new IOException("short read of DER bit string");
        }
        return byArray;
    }

    int a() throws IOException {
        return 0xFF & this.a.read();
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (this.a.read(byArray) != byArray.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.a);
    }

    public BigInt getEnumerated() throws IOException {
        if (this.a.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.a.a(DerInputStream.a(this.a));
    }

    public Date getGeneralizedTime() throws IOException {
        int n2;
        if (this.a.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        if (this.a.available() < 13) {
            throw new IOException("DER input, GeneralizedTime short input");
        }
        int n3 = DerInputStream.a(this.a);
        int n4 = 1000 * Character.digit((char)this.a.read(), 10);
        n4 += 100 * Character.digit((char)this.a.read(), 10);
        n4 += 10 * Character.digit((char)this.a.read(), 10);
        n4 += Character.digit((char)this.a.read(), 10);
        int n5 = 10 * Character.digit((char)this.a.read(), 10);
        n5 += Character.digit((char)this.a.read(), 10);
        --n5;
        int n6 = 10 * Character.digit((char)this.a.read(), 10);
        n6 += Character.digit((char)this.a.read(), 10);
        int n7 = 10 * Character.digit((char)this.a.read(), 10);
        n7 += Character.digit((char)this.a.read(), 10);
        int n8 = 10 * Character.digit((char)this.a.read(), 10);
        n8 += Character.digit((char)this.a.read(), 10);
        if ((n3 -= 12) == 3 || n3 == 7) {
            n2 = 10 * Character.digit((char)this.a.read(), 10);
            n2 += Character.digit((char)this.a.read(), 10);
            n3 -= 2;
        } else {
            n2 = 0;
        }
        if (n5 < 0 || n6 <= 0 || n5 > 11 || n6 > 31 || n7 >= 24 || n8 >= 60 || n2 >= 60) {
            throw new IOException("Parse Generalized time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n4, n5, n6, n7, n8, n2);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l2 = date.getTime();
        if (n3 != 1 && n3 != 5) {
            throw new IOException("Parse Generalized time, invalid offset");
        }
        switch (this.a.read()) {
            case 43: {
                int n9 = 10 * Character.digit((char)this.a.read(), 10);
                int n10 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n9 += Character.digit((char)this.a.read(), 10)) >= 24 || (n10 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, +hhmm");
                }
                l2 += (long)((n9 * 60 + n10) * 60 * 1000);
                break;
            }
            case 45: {
                int n11 = 10 * Character.digit((char)this.a.read(), 10);
                int n12 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n11 += Character.digit((char)this.a.read(), 10)) >= 24 || (n12 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, -hhmm");
                }
                l2 -= (long)((n11 * 60 + n12) * 60 * 1000);
                break;
            }
            default: {
                throw new IOException("Parse GeneralizedTime, garbage offset");
            }
            case 90: 
        }
        date.setTime(l2);
        return date;
    }

    public BigInt getInteger() throws IOException {
        if (this.a.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.a.a(DerInputStream.a(this.a));
    }

    int b() throws IOException {
        return DerInputStream.a(this.a);
    }

    static int a(int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4 = n2;
        if ((n4 & 0x80) == 0) {
            n3 = n4;
        } else {
            if ((n4 &= 0x7F) == 0) {
                return -1;
            }
            if (n4 < 0 || n4 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n4 + ", " + (n4 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n3 = 0;
            while (n4 > 0) {
                n3 <<= 8;
                n3 += 0xFF & inputStream.read();
                --n4;
            }
        }
        return n3;
    }

    static int a(InputStream inputStream) throws IOException {
        return DerInputStream.a(inputStream.read(), inputStream);
    }

    public void getNull() throws IOException {
        if (this.a.read() != 5 || this.a.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public byte[] getOctetString() throws IOException {
        if (this.a.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int n2 = DerInputStream.a(this.a);
        byte[] byArray = new byte[n2];
        if (this.a.read(byArray) != n2) {
            throw new IOException("short read of DER octet string");
        }
        return byArray;
    }

    public DerValue[] getSequence(int n2) throws IOException {
        if (this.a.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n2);
    }

    public DerValue[] getSet(int n2) throws IOException {
        if (this.a.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n2);
    }

    public DerValue[] getSet(int n2, boolean bl2) throws IOException {
        int n3 = this.a.read();
        if (!bl2 && n3 != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n2);
    }

    public Date getUTCTime() throws IOException {
        int n2;
        if (this.a.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        if (this.a.available() < 11) {
            throw new IOException("DER input, UTCtime short input");
        }
        int n3 = DerInputStream.a(this.a);
        if (n3 < 11 || n3 > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        int n4 = 10 * Character.digit((char)this.a.read(), 10);
        n4 = (n4 += Character.digit((char)this.a.read(), 10)) <= 50 ? (n4 += 2000) : (n4 += 1900);
        int n5 = 10 * Character.digit((char)this.a.read(), 10);
        n5 += Character.digit((char)this.a.read(), 10);
        --n5;
        int n6 = 10 * Character.digit((char)this.a.read(), 10);
        n6 += Character.digit((char)this.a.read(), 10);
        int n7 = 10 * Character.digit((char)this.a.read(), 10);
        n7 += Character.digit((char)this.a.read(), 10);
        int n8 = 10 * Character.digit((char)this.a.read(), 10);
        n8 += Character.digit((char)this.a.read(), 10);
        if ((n3 -= 10) == 3 || n3 == 7) {
            n2 = 10 * Character.digit((char)this.a.read(), 10);
            n2 += Character.digit((char)this.a.read(), 10);
            n3 -= 2;
        } else {
            n2 = 0;
        }
        if (n5 < 0 || n6 <= 0 || n5 > 11 || n6 > 31 || n7 >= 24 || n8 >= 60 || n2 >= 60) {
            throw new IOException("Parse UTC time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n4, n5, n6, n7, n8, n2);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l2 = date.getTime() / 1000L * 1000L;
        if (n3 != 1 && n3 != 5) {
            throw new IOException("Parse UTC time, invalid offset");
        }
        switch (this.a.read()) {
            case 43: {
                int n9 = 10 * Character.digit((char)this.a.read(), 10);
                int n10 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n9 += Character.digit((char)this.a.read(), 10)) >= 24 || (n10 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, +hhmm");
                }
                l2 += (long)((n9 * 60 + n10) * 60 * 1000);
                break;
            }
            case 45: {
                int n11 = 10 * Character.digit((char)this.a.read(), 10);
                int n12 = 10 * Character.digit((char)this.a.read(), 10);
                if ((n11 += Character.digit((char)this.a.read(), 10)) >= 24 || (n12 += Character.digit((char)this.a.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, -hhmm");
                }
                l2 -= (long)((n11 * 60 + n12) * 60 * 1000);
                break;
            }
            default: {
                throw new IOException("Parse UTCtime, garbage offset");
            }
            case 90: 
        }
        date.setTime(l2);
        return date;
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.a.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int n2 = DerInputStream.a(this.a) - 1;
        int n3 = n2 * 8 - this.a.read();
        byte[] byArray = new byte[n2];
        if (this.a.read(byArray) != n2) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(n3, byArray);
    }

    private void a(byte[] byArray, int n2, int n3) {
        if (t.d(byArray[n2 + 1])) {
            try {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                t t2 = new t();
                this.a = new DerInputBuffer(t2.a(byArray2));
            }
            catch (IOException iOException) {}
        } else {
            this.a = new DerInputBuffer(byArray, n2, n3);
        }
        this.a.mark(Integer.MAX_VALUE);
    }

    public void mark(int n2) {
        this.a.mark(n2);
    }

    public int peekByte() throws IOException {
        return this.a.d();
    }

    protected DerValue[] readVector(int n2) throws IOException {
        int n3 = DerInputStream.a(this.a);
        if (n3 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.a.available() == n3 ? this : this.subStream(n3, true);
        Vector<DerValue> vector = new Vector<DerValue>(n2, 5);
        do {
            DerValue derValue = new DerValue(derInputStream.a);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int n4 = vector.size();
        DerValue[] derValueArray = new DerValue[n4];
        int n5 = 0;
        while (n5 < n4) {
            derValueArray[n5] = (DerValue)vector.elementAt(n5);
            ++n5;
        }
        return derValueArray;
    }

    public void reset() {
        this.a.reset();
    }

    public DerInputStream subStream(int n2, boolean bl2) throws IOException {
        DerInputBuffer derInputBuffer = this.a.a();
        derInputBuffer.b(n2);
        if (bl2) {
            this.a.skip(n2);
        }
        return new DerInputStream(derInputBuffer);
    }

    public byte[] toByteArray() {
        return this.a.e();
    }
}

