/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.a1;
import COM.rsa.jsafe.ag;
import COM.rsa.jsafe.av;
import COM.rsa.jsafe.dg;
import COM.rsa.jsafe.v;
import COM.rsa.jsafe.z;
import com.sun.net.ssl.internal.ssl.JS_PrivateKey;
import com.sun.net.ssl.internal.ssl.JS_PublicKey;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class JS_Signature
extends SignatureSpi
implements Cloneable,
Serializable {
    protected ag jsafeSignature;
    protected dg jsafeParams;
    protected int[] signatureParams;
    private String a;
    private boolean b;

    public JS_Signature(String string, String string2, String string3) throws NoSuchAlgorithmException {
        try {
            this.jsafeSignature = ag.a(string, "Java");
        }
        catch (z z2) {
            throw new NoSuchAlgorithmException("JSAFE provider does not perform " + string);
        }
        this.a = string3;
    }

    void a() {
        if (this.jsafeSignature != null) {
            this.jsafeSignature.a();
        }
        this.jsafeSignature = null;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Class<?> clazz = Class.forName(this.getSubclassName());
            JS_Signature jS_Signature = (JS_Signature)clazz.newInstance();
            return jS_Signature;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CloneNotSupportedException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException();
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.b = true;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PrivateKey jS_PrivateKey = (JS_PrivateKey)keyFactory.translateKey(privateKey);
            av av2 = jS_PrivateKey.b();
            SecureRandom secureRandom = null;
            if (this.needSignRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2;
                        secureRandom = secureRandom2 = a1.getInstance("SHA1Random", "Java");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(av2, this.jsafeParams, secureRandom);
            av2.a();
            jS_PrivateKey.a();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for signing with the given key.");
        }
        catch (z z2) {
            throw new InvalidKeyException(z2.getMessage());
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (secureRandom != null) {
            this.appRandom = secureRandom;
        }
        this.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.b = false;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PublicKey jS_PublicKey = (JS_PublicKey)keyFactory.translateKey(publicKey);
            v v2 = jS_PublicKey.b();
            SecureRandom secureRandom = null;
            if (this.needVerifyRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2 = a1.getInstance("SHA1Random", "Java");
                        secureRandom = this.appRandom;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(v2, this.jsafeParams, secureRandom);
            v2.a();
            jS_PublicKey.a();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for verifying with the given key.");
        }
        catch (z z2) {
            throw new InvalidKeyException(z2.getMessage());
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        dg dg2 = this.getSystemParameters(algorithmParameterSpec);
    }

    protected byte[] engineSign() throws SignatureException {
        if (!this.b) {
            throw new SignatureException("Object initialized for verify.");
        }
        try {
            byte[] byArray = this.jsafeSignature.j();
            this.jsafeSignature.k();
            return byArray;
        }
        catch (z z2) {
            throw new SignatureException(z2.getMessage());
        }
    }

    protected void engineUpdate(byte by2) throws SignatureException {
        try {
            byte[] byArray = new byte[]{by2};
            if (this.b) {
                this.jsafeSignature.a(byArray, 0, 1);
            } else {
                this.jsafeSignature.c(byArray, 0, 1);
            }
        }
        catch (z z2) {
            throw new SignatureException(z2.getMessage());
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        try {
            if (this.b) {
                this.jsafeSignature.a(byArray, n2, n3);
            } else {
                this.jsafeSignature.c(byArray, n2, n3);
            }
        }
        catch (z z2) {
            throw new SignatureException(z2.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.b) {
            throw new SignatureException("Object initialized for signing.");
        }
        try {
            boolean bl2 = this.jsafeSignature.b(byArray, 0, byArray.length);
            this.jsafeSignature.l();
            return bl2;
        }
        catch (z z2) {
            throw new SignatureException(z2.getMessage());
        }
    }

    protected void finalize() {
        this.a();
    }

    protected abstract int[] getSignatureParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected String getSubclassName() {
        return null;
    }

    protected abstract dg getSystemParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected boolean needSignRandom() {
        return false;
    }

    protected boolean needVerifyRandom() {
        return false;
    }
}

