/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeSet;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.NamespacedNode;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementNode
extends NamespacedNode
implements ElementEx {
    private AttributeSet attributes;
    private String idAttributeName;
    private Object userObject;
    private static final char[] tagStart = new char[]{'<', '/'};
    private static final char[] tagEnd = new char[]{' ', '/', '>'};

    public ElementNode() {
    }

    public ElementNode(String name) {
        this.name = name;
    }

    public ElementNode(String namespaceURI, String qName) throws DomEx {
        this.checkArguments(namespaceURI, qName);
        this.name = qName;
        this.namespaceURI = namespaceURI;
    }

    private void checkArguments(String namespaceURI, String qualifiedName) throws DomEx {
        if (qualifiedName == null) {
            throw new DomEx(14);
        }
        int first = qualifiedName.indexOf(58);
        if (first <= 0) {
            if (!XmlNames.isUnqualifiedName(qualifiedName)) {
                throw new DomEx(5);
            }
            return;
        }
        int last = qualifiedName.lastIndexOf(58);
        if (last != first) {
            throw new DomEx(14);
        }
        String prefix = qualifiedName.substring(0, first);
        String localName = qualifiedName.substring(first + 1);
        if (!XmlNames.isUnqualifiedName(prefix) || !XmlNames.isUnqualifiedName(localName)) {
            throw new DomEx(5);
        }
        if (namespaceURI == null || namespaceURI.equals("") || prefix.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            throw new DomEx(14);
        }
    }

    public void trimToSize() {
        super.trimToSize();
        if (this.attributes != null) {
            this.attributes.trimToSize();
        }
    }

    protected void setTag(String t) {
        this.name = t;
    }

    void setAttributes(AttributeSet a) {
        AttributeSet oldAtts = this.attributes;
        if (oldAtts != null && oldAtts.isReadonly()) {
            throw new DomEx(7);
        }
        if (a != null) {
            a.setOwnerElement(this);
        }
        this.attributes = a;
        if (oldAtts != null) {
            oldAtts.setOwnerElement(null);
        }
    }

    void checkChildType(int type) throws DOMException {
        switch (type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public void setReadonly(boolean deep) {
        if (this.attributes != null) {
            this.attributes.setReadonly();
        }
        super.setReadonly(deep);
    }

    public NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public String toString() {
        try {
            CharArrayWriter out = new CharArrayWriter();
            XmlWriteContext x = new XmlWriteContext(out);
            this.writeXml(x);
            return out.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        if (this.name == null) {
            throw new IllegalStateException(this.getMessage("EN-002"));
        }
        out.write(tagStart, 0, 1);
        out.write(this.name);
        if (this.attributes != null) {
            this.attributes.writeXml(context);
        }
        if (!this.hasChildNodes()) {
            out.write(tagEnd, 0, 3);
        } else {
            out.write(tagEnd, 2, 1);
            this.writeChildrenXml(context);
            out.write(tagStart, 0, 2);
            out.write(this.name);
            out.write(tagEnd, 2, 1);
        }
    }

    public void setIdAttributeName(String attName) {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.idAttributeName = attName;
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        return this.name;
    }

    public String getNodeName() {
        return this.name;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public String getAttribute(String name) {
        return this.attributes == null ? "" : this.attributes.getValue(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (localName == null) {
            return null;
        }
        if (this.attributes == null) {
            return null;
        }
        int i = 0;
        AttributeNode attr;
        while ((attr = (AttributeNode)this.attributes.item(i)) != null) {
            if (attr.getLocalName().equals(localName) && attr.getNamespaceURI().equals(namespaceURI)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public void setAttribute(String name, String value) throws DOMException {
        AttributeNode att;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        if ((att = (AttributeNode)this.attributes.getNamedItem(name)) != null) {
            att.setNodeValue(value);
        } else {
            att = new AttributeNode(name, value, true, null);
            att.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.attributes.setNamedItem(att);
        }
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttributeNode.checkArguments(namespaceURI, qualifiedName);
        String prefix = XmlNames.getPrefix(qualifiedName);
        Attr attr = this.getAttributeNodeNS(namespaceURI, XmlNames.getLocalPart(qualifiedName));
        if (attr == null) {
            AttributeNode newAttr = new AttributeNode(namespaceURI, qualifiedName, value, true, null);
            newAttr.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            this.setAttributeNodeNS(newAttr);
        } else {
            attr.setValue(value);
            attr.setPrefix(prefix);
        }
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (newAttr.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItemNS(newAttr);
    }

    public void removeAttribute(String name) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (this.attributes == null) {
            throw new DomEx(8);
        }
        this.attributes.removeNamedItem(name);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        this.attributes.removeNamedItemNS(namespaceURI, localName);
    }

    public Attr getAttributeNode(String name) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(name);
        }
        return null;
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(newAttr instanceof AttributeNode)) {
            throw new DomEx(4);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeSet(this);
        }
        return (Attr)this.attributes.setNamedItem(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        Attr attr = this.getAttributeNode(oldAttr.getNodeName());
        if (attr == null) {
            throw new DomEx(8);
        }
        this.removeAttribute(attr.getNodeName());
        return attr;
    }

    /*
     * WARNING - void declaration
     */
    public Node cloneNode(boolean deep) {
        try {
            void e;
            ElementNode retval = (ElementNode)this.getOwnerDocument().createElement(this.name);
            if (this.attributes != null) {
                retval.setAttributes(new AttributeSet(this.attributes, true));
            }
            if (deep) {
                Node node;
                int i = 0;
                while ((node = this.item(i)) != null) {
                    retval.appendChild(node.cloneNode(true));
                    ++i;
                }
            }
            return e;
        }
        catch (DOMException e) {
            throw new RuntimeException(this.getMessage("EN-001"));
        }
    }

    public void write(Writer out) throws IOException {
        this.writeXml(new XmlWriteContext(out));
    }
}

