package com.evermind.taglib.util;

import java.util.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.naming.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class SendMailTag extends BodyTagSupport
{
	private String from;
	private String to;
	private String sessionLocation;
	private String contentType;
	private String encoding;
	private String subject;
	
	public void setSubject(String subject)
	{
		this.subject = subject;
	}

	public void setFrom(String from)
	{
		this.from = from;
	}

	public void setTo(String to)
	{
		this.to = to;
	}
	
	public void setSession(String session)
	{
		this.sessionLocation = session;
	}
	
	public int doStartTag()
	{
		return EVAL_BODY_TAG;
	}
	
	public int doEndTag() throws JspTagException
	{
		if(this.bodyContent != null && to != null)
		{
			String content = bodyContent.getString();

			try
			{
				Context context = new InitialContext();		
	//			mailSession.
				Session mailSession = null;
				
				if(sessionLocation != null)
					mailSession = (Session)context.lookup(sessionLocation);
				else
					mailSession = Session.getDefaultInstance(new Properties(), null);

				// create a message
				MimeMessage message = new MimeMessage(mailSession);
		
				if(from != null)
					message.setFrom(new InternetAddress(from));

				if(encoding == null)
					encoding = "utf-8";

				message.setHeader("Content-Type", "text/html");
				message.setRecipients(Message.RecipientType.TO, new InternetAddress[] { new InternetAddress(to) });
				message.setSubject(subject, encoding);
				message.setSentDate(new Date());
				message.setText(content, encoding);

				Transport.send(message);
			}
			catch(NamingException e)
			{
				throw new JspTagException("NamingException: " + e.getMessage());
			}
			catch(ClassCastException e)
			{
				throw new JspTagException(sessionLocation + " didnt contain a javax.mail.Session");
			}
			catch(MessagingException e)
			{
				throw new JspTagException("Error sending mail: " + e.getMessage());
			}
		}

		return EVAL_PAGE;
	}
}
