package com.evermind.taglib.util;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.util.*;

/**
 * A Tag that displays a given Date formated for a given locale. 
 * If locale is not given, the locale of the request is used.
 * if the request locale is null, the default locale is used
 * @author Magnus Rydin
 */
public class DisplayDateTag implements Tag 
{
  PageContext pageContext;
  Tag parent;
  Date date;
  Locale locale;
  
  /** 
   * Method used by the JSP container to set the parameter date
   */
  public void setDate(Date date) 
  {
    this.date=date;
  }
  
   /** 
   * Method used by the JSP container to set the parameter locale
   */
  public void setLocale(Locale locale) 
  {
    this.locale=locale;
  }

  /** 
   * Method called before body
   * @return either a EVAL_BODY or a SKIP_BODY
   */
  public int doStartTag() throws javax.servlet.jsp.JspException 
  {
    return SKIP_BODY;
  }
  
  /** 
   * Method Called after body
   * @return either EVAL_PAGE or SKIP_PAGE
   */
  public int doEndTag() throws javax.servlet.jsp.JspException 
  {
    //if no locale was specified, use the locale specified in the request
    if(locale==null){
      locale=pageContext.getRequest().getLocale();
    }
    //if no locale was found in the request, use the default locale
    if(locale==null){
      locale=Locale.getDefault();
    }
    try{
      //present the localized date
      pageContext.getOut().write(java.text.DateFormat.getDateTimeInstance(java.text.DateFormat.SHORT,java.text.DateFormat.SHORT,locale).format(date));    
    }catch(java.io.IOException e){
      throw new JspException("IOException: " + e.getMessage());
    }
    return EVAL_PAGE;
  }
  
  /** 
   * Method called to releases all resources
   */
  public void release() {}
  
  /** Method used by the JSP container to set the current PageContext
   * @param pageContext, the current PageContext
   */
  public void setPageContext(final javax.servlet.jsp.PageContext pageContext) 
  {
    this.pageContext=pageContext;
  }
  
  /** Method used by the JSP container to set the parent of the Tag
   * @param parent, the parent Tag
   */
  public void setParent(final javax.servlet.jsp.tagext.Tag parent) 
  {
    this.parent=parent;
  }
  
  /** Method for retrieving the parent
   * @return the parent
   */
  public javax.servlet.jsp.tagext.Tag getParent() {
    return parent;
  }
}
