package com.evermind.taglib.util;

import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * Includes the body if the user is in the specified role.
 */
public class IfInRoleTag extends TagSupport
{
	private String role;
	private boolean include = true;
	
	public void setRole(String role)
	{
		this.role = role;
	}
	
	public void setInclude(boolean include)
	{
		this.include = include;
	}

	public int doStartTag()
	{
		return ((HttpServletRequest)pageContext.getRequest()).isUserInRole(role) == include ? EVAL_BODY_INCLUDE : SKIP_BODY;
	}
}
