import java.io.IOException;
import javax.naming.*;
import com.evermind.security.*;
import javax.servlet.http.HttpSession;
import com.sun.estore.account.ejb.DuplicateAccountException;
import java.security.*;

public class OrionSecurityAdapter implements com.sun.estore.util.SecurityAdapter
{
	public void addUser(String realm, String role, String username, String password) throws DuplicateAccountException
	{
		if(role.equals("gold"))
			role = "gold_customer";

		System.out.println("OrionSecurityAdapter.addUser(" + username + ")");

		try
		{
			RoleManager roleManager = (RoleManager)new InitialContext().lookup("java:comp/RoleManager");
		
			if(roleManager.getPrincipal(username) != null)
				throw new DuplicateAccountException(username);

			Principal principal = roleManager.createPrincipal(username, password);
			roleManager.addToRole(principal, role);
			roleManager.store();
		}
		catch(NamingException e)
		{
			throw new RuntimeException("NamingException: " + e.getMessage());
		}
		catch(UserAlreadyExistsException e)
		{
			throw new DuplicateAccountException(username);
		}
		catch(InstantiationException e)
		{
			throw new DuplicateAccountException("Error creating user: " + e.getMessage());
		}
		catch(IOException e)
		{
			throw new RuntimeException("IO Error: " + e.getMessage());
		}
	}

	public void loginUser(String username, String password, HttpSession session)
	{
		System.out.println("OrionSecurityAdapter.login(" + username + ", " + password + ")");

		try
		{
			RoleManager roleManager = (RoleManager)new InitialContext().lookup("java:comp/RoleManager");
			roleManager.login(username, password);
		}
		catch(NamingException e)
		{
			throw new RuntimeException("NamingException: " + e.getMessage());
		}
	}
}
