<?php
/* $Id: sql.php,v 1.20 2002/07/08 16:19:46 killroyboy Exp $ */
// 	File:		sql.php
// 	Purpose:	Run any and a lot of the general straight sql statments

include("lib.inc.php");
$no_include = true;
// Go back to further page if table should not be dropped
if (isset($btnDrop) && $btnDrop != $strYes) {
	$sql_query = stripslashes($sql_query);
	if (file_exists("./$goto")) {
		include(preg_replace('/\.\.*/', '.', $goto));
	} else {
		Header("Location: $goto");
	}
	exit;
}


// Check if query needs confirmation
$is_drop_sql_query = eregi("[[:space:]]*(DROP|ALTER|DELETE)[[:space:]]+", urldecode($sql_query)); // Get word "drop"

if (!$cfgConfirm) {
   $btnDrop = $strYes;
}

if ($is_drop_sql_query && !isset($btnDrop)) {
   include("header.inc.php");
   echo $strDoYouReally.urldecode(stripslashes(nl2br(htmlentities($sql_query))))."?<br>";
	if (eregi("(CREATE|DROP)[[:space:]]+(TABLE|DATABASE)[[:space:]]+", urldecode($sql_query))) {
		$reload = "true";
	}
	if (!empty($edit_action)) {
		$sql_query = urldecode($sql_query);
		$goto = urldecode($goto);
	}
   ?>
   <form action="sql.php" method="post" enctype="application/x-www-form-urlencoded">
   <input type="hidden" name="sql_query" value="<?php echo htmlspecialchars(stripslashes($sql_query)); ?>">
   <input type="hidden" name="server" value="<?php echo $server ?>">
   <input type="hidden" name="db" value="<?php echo $db ?>">
   <input type="hidden" name="zero_rows" value="<?php echo $zero_rows;?>">   
   <input type="hidden" name="table" value="<?php echo $table;?>">   
   <input type="hidden" name="goto" value="<?php echo $goto;?>">
   <input type="hidden" name="reload" value="<?php echo $reload;?>">   
   <input type="hidden" name="rel_type" value="<?php echo $rel_type;?>">   
   <input type="Submit" name="btnDrop" value="<?php echo $strYes; ?>">
   <input type="Submit" name="btnDrop" value="<?php echo $strNo; ?>">
   </form>
   <?php 
} else {
	if (eregi("(CREATE|DROP)[[:space:]]+(TABLE|DATABASE)[[:space:]]+", $sql_query)) {
		$reload = "true";
	}

	if (!empty($sql_query)) {
		$sql_query = isset($sql_query) ? trim(stripslashes($sql_query)) : '';
		$sql_order = isset($sql_order) ? trim(stripslashes($sql_order)) : '';

		$select_parse = "^SELECT[[:space:]]+.+[[:space:]]FROM[[:space:]]+[\"]*([[:alnum:]_]+)[\"]*[[:space:]]*[WHERE]*[[:space:]]*(.*)";
		if (empty($table)) {
			if (eregi($select_parse, trim(stripslashes($sql_query)), $qr_parts)) {
				$table = $qr_parts[1];
			}
		}

		if (!empty($table)) {
			// Pull in the primary keys for this table
			$pri_query = "
				SELECT 
					ic.relname AS index_name, 
					bc.relname AS tab_name, 
					ta.attname AS column_name,
					i.indisunique AS unique_key,
					i.indisprimary AS primary_key
				FROM 
					pg_class bc,
					pg_class ic,
					pg_index i,
					pg_attribute ta,
					pg_attribute ia
				WHERE 
					bc.oid = i.indrelid
					AND ic.oid = i.indexrelid
					AND ia.attrelid = i.indexrelid
					AND ta.attrelid = bc.oid
					AND bc.relname = '$table'
					AND ta.attrelid = i.indrelid
					AND ta.attnum = i.indkey[ia.attnum-1]
				ORDER BY 
					index_name, tab_name, column_name
			";
		
			$pri_result = @pg_exec($link, pre_query($pri_query)) or pg_die(pg_errormessage(), $pri_query, __FILE__, __LINE__);
			$pri_num = @pg_numrows($pri_result);
			
			for ($i_pri_rows = 0; $i_pri_rows < $pri_num; $i_pri_rows++) {
				$pri_row = pg_fetch_array($pri_result, $i_pri_rows, PGSQL_ASSOC);
				if ($pri_row['primary_key'] == "t" || $pri_row['unique_key'] == "t") {
					$pri_keys[] = $pri_row['column_name'];
				}
			}
		} elseif (eregi("SELECT[[:space:]]+", $sql_query)) {
			echo "<p class=\"generic\">No table detected... unable to retrieve primary or unique keys for edit/delete</p>";
		}
		
		$sql_query = isset($sql_query) ? stripslashes($sql_query) : '';
		$sql_order = isset($sql_order) ? stripslashes($sql_order) : '';
		if (!$limited) {
			if (!$result = @pg_exec($link, pre_query($sql_query . " " . $sql_order))) {
				include("header.inc.php");
				pg_die(pg_errormessage($link), $sql_query . " " . $sql_order, __FILE__, __LINE__);
			}
			$num_rows = @pg_numrows($result);
			if ($num_rows < 1 || ($rel_type == "sequence" && eregi($sql_query, "setval"))) {
				if (eregi("(DELETE|INSERT|UPDATE)[[:space:]]+", $sql_query)) {
					$affected_rows = @pg_cmdtuples($result);
				} else {
					unset($affected_rows);
				}
				if (ereg("\?", $goto)) {
					$message = $zero_rows;
					Header("Location: $goto");
				} elseif (file_exists("./$goto")) {
					include("header.inc.php");
					if (isset($zero_rows) && !empty($zero_rows)) {
						$message = $zero_rows;
					} else {
						$message = $strEmptyResultSet;
					}
					include(preg_replace('/\.\.*/', '.', $goto));
				}
				exit;
			} else {
				include("header.inc.php");
				$query = display_table($result, $limited);
			}
		} else {
			include("header.inc.php");
			$query = display_table($result, $limited);
		}
	
		echo "<br><li><a href=\"rep_create.php?server=$server&db_name=$db&rep_sql=", urlencode($sql_query), "\">$strCreateNew $strReport</a><br>";
		echo "<li><a href=\"javascript:window.location.reload()\">$strRefresh</a><br><br>";
		switch ($rel_type) {
			case "sequence"	:
				$sql_query = urlencode("SELECT SETVAL('$sequence', 1)");
				$goto = urlencode($GLOBALS['QUERY_STRING']);
				echo "<li><a href=\"sql.php?server=$server&db=$db&table=$table&sql_query=$sql_query&goto=$goto\">Reset</a>";
				break;
			default:
				if ($cfgShowSQL) {
					show_message("Your SQL statment");
				}
				if (!empty($query)) {
					echo "<br><li><a href=\"tbl_change.php?$query\">$strInsert</a>";
				}
				break;
		}
	}
}
include ("footer.inc.php");
?>
