<?php
// File: $Id: phplive.php,v 1.6 2002/02/25 08:19:23 johnnyrocket Exp $ $Name:  $
// ----------------------------------------------------------------------
// POST-NUKE Content Management System
// Copyright (C) 2001 by the Post-Nuke Development Team.
// http://www.postnuke.com/
// ----------------------------------------------------------------------
// Based on:
// PHP-NUKE Web Portal System - http://phpnuke.org/
// Thatware - http://thatware.org/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Original Author of file: Sascha Endlicher (Karateka)
// Purpose of file: live support plus real time tracking of users
// ----------------------------------------------------------------------

$blocks_modules['phplive'] = array(
    'func_display' => 'blocks_phplive',
    'func_edit' => 'blocks_phplive_select',
    'func_update' => 'blocks_phplive_update',
    'text_type' => 'phplive',
    'text_type_long' => 'Livesupport',
    'allow_multiple' => false,
    'form_content' => false,
    'form_refresh' => false,
//  'support_xhtml' => true,
    'show_preview' => true
);

// Security
pnSecAddSchema('Supportblock::', 'Block title::');

function blocks_phplive($row)
{
    global $pntable, $dbconn;

    if (!pnSecAuthAction(0, 'Supportblock::', "$row[title]::", ACCESS_READ))
    {
        return;
    }

    // Break out options from our content field
    $vars = pnBlockVarsFromContent($row['content']);

    // Default values
    if (empty($vars['company']))
    {
        $vars['company'] = "Demo";
    }
    if (empty($vars['id']))
    {
        $vars['id'] = 3;
    }

    $content = "<script type=\"text/javascript\" language=\"javascript\" src=\"javascript/phplive.php?company=".$vars['company']."&id=".$vars['id']."\"></script>\n";
    if (pnSecAuthAction(0, 'Supportblock::', '::', ACCESS_ADD))
    {
        $content.= "<br /><a href=\"http://www.livepeople.info/support/web/".$vars['company']."\" target=\"_blank\">"._LPLOGIN."</a>";
    }
    if (empty($row['title'])) {
        $row['title'] = _LIVESUPPORT;
    }
    $row['content'] = $content;
    themesideblock($row);
}

function blocks_phplive_select($row)
{
    global $pntable, $dbconn;

    // Break out options from our content field
    $vars = pnBlockVarsFromContent($row['content']);

    // Default values
    if (empty($vars['company']))
    {
        $vars['company'] = "Demo";
    }
    if (empty($vars['id']))
    {
        $vars['id'] = 3;
    }

    $row['content'] = "";

    // Number of stories
    $output = "<tr><td class=\"pn-normal\">"._LPCOMPANY."</td><td><input type=\"text\" name=\"company\" size=\"15\" value=\"" . pnVarPrepForDisplay($vars['company']) . "\"></td></tr>\n";
    $output.= "<tr><td class=\"pn-normal\">"._LPUID."</td><td><input type=\"text\" name=\"id\" size=\"6\" value=\"" . pnVarPrepForDisplay($vars['id']) . "\"></td></tr>";
    $output.= "<tr><td class=\"pn-normal\" colspan=\"2\">"._LPFREE."</td></tr>";
    return $output;
}

function blocks_phplive_update($row)
{
    list($vars['company'],
         $vars['id']) = pnVarCleanFromInput('company',
					    'id');

    $row['content'] = pnBlockVarsToContent($vars);

    return($row);
}
?>