<?php
// File: $Id: dl-rating.php,v 1.13.2.2 2002/05/15 20:48:20 byronmhome Exp $ $Name:  $
// ----------------------------------------------------------------------
// POST-NUKE Content Management System
// Copyright (C) 2001 by the Post-Nuke Development Team.
// http://www.postnuke.com/
// ----------------------------------------------------------------------
// Based on:
// PHP-NUKE Web Portal System - http://phpnuke.org/
// Thatware - http://thatware.org/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Original Author of file: Francisco Burzi
// Purpose of file:
// ----------------------------------------------------------------------

/**
 * @usedby index
 */
function rateinfo($lid) {
    global $ModName, $dbname;

    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $itemname = downloads_ItemNameFromIID($lid);
    $catname = downloads_CatNameFromIID($lid);
    if (!(pnSecAuthAction(0, 'Downloads::Item', "$itemname:$catname:$lid", ACCESS_COMMENT))) {
        echo _DOWNLOADSACCESSNOAUTH;
        include 'footer.php';
        return;
    }

    $column = &$pntable['downloads_downloads_column'];
    $dbconn->Execute("UPDATE $pntable[downloads_downloads]
                    SET $column[hits] =$column[hits]+1
                    WHERE $column[lid]=".pnVarPrepForStore($lid)."");
    $result = $dbconn->Execute("SELECT $column[url]
                              FROM $pntable[downloads_downloads]
                              WHERE $column[lid]=".pnVarPrepForStore($lid)."");
    list($url) = $result->fields;
    Header("Location: ".$url);
}

/**
 *@usedby index, navigation
 */
function addrating($ratinglid, $ratinguser, $rating, $ratinghost_name, $ratingcomments)
{
    global $ModName;

    $anonymous = pnConfigGetVar('anonymous');

    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $passtest = "yes";
    include("header.php");
    include(WHERE_IS_PERSO."config.php");


    $itemname = downloads_ItemNameFromIID($ratinglid);
    $catname = downloads_CatNameFromIID($ratinglid);
    if(!isset($lid)) $lid = '';
    if (!(pnSecAuthAction(0, 'Downloads::Item', "$itemname:$catname:$lid", ACCESS_COMMENT))) {
        echo _DOWNLOADSACCESSNOAUTH;
        include 'footer.php';
        return;
    }

    completevoteheader();
    if (pnUserLoggedIn()) {
        $ratinguser = pnUserGetVar('uname');
    } else if ($ratinguser=="outside") {
        $ratinguser = "outside";
    } else {
        $ratinguser = pnConfigGetVar("anonymous");
    }
    $column = &$pntable['downloads_downloads_column'];
    $results3 = $dbconn->Execute("SELECT $column[title]
                                FROM $pntable[downloads_downloads]
                                WHERE $column[lid]=".pnVarPrepForStore($ratinglid)."");
   while(list($title)=$results3->fields)   {
        $ttitle = $title;
        $results3->MoveNext();
    }
    /* Make sure only 1 anonymous from an IP in a single day. */
    $ip = getenv("REMOTE_HOST");
    if (empty($ip)) {
       $ip = getenv("REMOTE_ADDR");
    }
    /* Check if Rating is Null */
    if ($rating=="--") {
        $error = "nullerror";
        completevote($error);
        $passtest = "no";
    }
    /* Check if Download POSTER is voting (UNLESS Anonymous users allowed to post) */
    if ($ratinguser != $anonymous && $ratinguser != "outside") {
        $column = &$pntable['downloads_downloads_column'];
        $result=$dbconn->Execute("SELECT $column[submitter]
                                FROM $pntable[downloads_downloads]
                                WHERE $column[lid]=".pnVarPrepForStore($ratinglid)."");
        while(list($ratinguserDB)=$result->fields) {

            $result->MoveNext();
            if ($ratinguserDB==$ratinguser) {
                $error = "postervote";
                completevote($error);
                $passtest = "no";
            }
        }
    }
    /* Check if REG user is trying to vote twice. */
    if ($ratinguser!=$anonymous && $ratinguser != "outside") {
        $column = &$pntable['downloads_votedata_column'];
        $result=$dbconn->Execute("SELECT $column[ratinguser] FROM $pntable[downloads_votedata] WHERE $column[ratinglid]=".pnVarPrepForStore($ratinglid)."");
        while(list($ratinguserDB)=$result->fields) {

            $result->MoveNext();
            if ($ratinguserDB==$ratinguser) {
                $error = "regflood";
                completevote($error);
                $passtest = "no";
            }
        }
    }
    /* Check if ANONYMOUS user is trying to vote more than once per day. */
    if ($ratinguser==$anonymous){
        $yesterdaytimestamp = (time()-(86400 * $anonwaitdays));
        $ytsDB = Date("Y-m-d H:i:s", $yesterdaytimestamp);
        $column = &$pntable['downloads_votedata_column'];
        $result=$dbconn->Execute("SELECT count(*)
                                FROM $pntable[downloads_votedata]
                                WHERE $column[ratinglid]=".pnVarPrepForStore($ratinglid)."
                                   AND $column[ratinguser]='".pnVarPrepForStore($anonymous)."'
                                   AND $column[ratinghostname] = '".pnVarPrepForStore($ip)."'
                                   AND TO_DAYS(NOW()) - TO_DAYS(".pnVarPrepForStore($column['ratingtimestamp']).") < ".pnVarPrepForStore($anonwaitdays)."");
        list($anonvotecount) = $result->fields;
        if ($anonvotecount >= 1) {
            $error = "anonflood";
            completevote($error);
            $passtest = "no";
        }
    }
    /* Check if OUTSIDE user is trying to vote more than once per day. */
    if ($ratinguser=="outside"){
        $yesterdaytimestamp = (time()-(86400 * $outsidewaitdays));
        $ytsDB = Date("Y-m-d H:i:s", $yesterdaytimestamp);
        $column = &$pntable['downloads_votedata_column'];
        $result=$dbconn->Execute("SELECT count(*) FROM $pntable[downloads_votedata]
                                WHERE $column[ratinglid]=".pnVarPrepForStore($ratinglid)."
                                   AND $column[ratinguser]='outside'
                                   AND $column[ratinghostname] = '".pnVarPrepForStore($ip)."'
                                   AND TO_DAYS(NOW()) - TO_DAYS(".pnVarPrepForStore($column['ratingtimestamp']).") < ".pnVarPrepForStore($outsidewaitdays)."");
        list($outsidevotecount) = $result->fields;
        if ($outsidevotecount >= 1) {
            $error = "outsideflood";
            completevote($error);
            $passtest = "no";
        }
    }
    /* Passed Tests */
    if ($passtest == "yes") {
        /* All is well.  Add to Line Item Rate to DB. */
         $column = &$pntable['downloads_votedata_column'];
         $dbconn->Execute("INSERT INTO $pntable[downloads_votedata]
                         ($column[ratingdbid], $column[ratinglid],
                         $column[ratinguser], $column[rating],
                         $column[ratinghostname], $column[ratingcomments],
                         $column[ratingtimestamp])
                         VALUES (NULL,'".pnVarPrepForStore($ratinglid)."', '".pnVarPrepForStore($ratinguser)."', '".pnVarPrepForStore($rating)."',
                          '".pnVarPrepForStore($ip)."', '".pnVarPrepForStore($ratingcomments)."', now())");
        /* All is well.  Calculate Score & Add to Summary (for quick retrieval & sorting) to DB. */
        /* NOTE: If weight is modified, ALL downloads need to be refreshed with new weight. */
        /*   Running a SQL statement with your modded calc for ALL downloads will accomplish this. */
        $voteresult = $dbconn->Execute("SELECT $column[rating], $column[ratinguser],
                                      $column[ratingcomments]
                                      FROM $pntable[downloads_votedata]
                                      WHERE $column[ratinglid] = ".pnVarPrepForStore($ratinglid)."");
        $totalvotesDB = $voteresult->PO_RecordCount();
        $finalrating = calculateVote($voteresult, $totalvotesDB);
        $column = &$pntable['downloads_downloads_column'];
        $dbconn->Execute("UPDATE $pntable[downloads_downloads]
                        SET $column[downloadratingsummary] = ".pnVarPrepForStore($finalrating).",
                            $column[totalvotes] = ".pnVarPrepForStore($totalvotesDB).",
                            $column[totalcomments] = ".pnVarPrepForStore($column['totalcomments'])." + 1
                        WHERE $column[lid] = ".pnVarPrepForStore($ratinglid)."");
        $error = "none";
        completevote($error);
    }
    completevotefooter($ratinglid, $ttitle, $ratinguser);
    include("footer.php");
}

function completevoteheader() {
    menu(1);

    OpenTable();
}

function completevotefooter($lid, $ttitle, $ratinguser)
{
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $itemname = downloads_ItemNameFromIID($lid);
    $catname = downloads_CatNameFromIID($lid);
    if (!(pnSecAuthAction(0, 'Downloads::Item', "$itemname:$catname:$lid", ACCESS_COMMENT))) {
        echo _DOWNLOADSACCESSNOAUTH;
        include 'footer.php';
        return;
    }

    $column = &$pntable['downloads_downloads_column'];
    $result=$dbconn->Execute("SELECT $column[url]
                            FROM $pntable[downloads_downloads]
                            WHERE $column[lid]=$lid");
    list($url)=$result->fields;
    echo "<font class=\"pn-normal\">"._THANKSTOTAKETIME.' '.pnConfigGetVar('sitename').'. '._DLETSDECIDE."</font><br><br><br>";
    if ($ratinguser=="outside") {
        echo "<center><font class=\"pn-normal\">".WEAPPREACIATE.' '.pnConfigGetVar('sitename')."!<br><a class=\"pn-normal\" href=\"$url\">"._RETURNTO." $ttitle</a></font><center><br><br>";
        $column = &$pntable['downloads_downloads_column'];
        $result=$dbconn->Execute("SELECT $column[title]
                                FROM $pntable[downloads_downloads]
                                WHERE $column[lid]=".pnVarPrepForStore($lid)."");
        list($title)=$result->fields;
        $ttitle = ereg_replace (" ", "_", $title);
    }
    echo "<center><font class=\"pn-normal\">";
    downloadinfomenu($lid,$ttitle);
    echo "</center></font>";
    CloseTable();
}

function completevote($error) {
    switch ($error) {
        case "none":
            echo "<center><font class=\"pn-title\">Your vote is appreciated.</font></center>";
            break;
        case "anonflood":
            echo "<center><font class=\"pn-title\">You have already voted for this download in the past ".pnVarPrepForStore($anonwaitdays)." day(s).</font></center><br>";
            break;
        case "regflood":
            echo "<center><font class=\"pn-title\">Vote for a download only once.<br>All votes are logged and reviewed.</font></center><br>";
            break;
        case "postervote":
            echo "<center><font class=\"pn-title\">You cannot vote on a download you submitted.<br>All votes are logged and reviewed.</font></center><br>";
            break;
        case "nullerror":
            echo "<center><font class=\"pn-title\">No rating selected - no vote tallied</font></center><br>";
            break;
        case "outsideflood":
            echo "<center><font class=\"pn-title\">Only one vote per IP address allowed every ".pnVarPrepForStore($outsidewaitdays)." day(s).</font></center><br>";
            break;
    }
}

/**
 * @usedby index
 */
function ratedownload($lid, $ttitle)
{
    include 'header.php';

    global $datetime, $ModName, $modurl;
    menu(1);

    $itemname = downloads_ItemNameFromIID($lid);
    $catname = downloads_CatNameFromIID($lid);
    if (!(pnSecAuthAction(0, 'Downloads::Item', "$itemname:$catname:$lid", ACCESS_COMMENT))) {
        echo _DOWNLOADSACCESSNOAUTH;
        include 'footer.php';
        return;
    }

    OpenTable();
    $transfertitle = ereg_replace ("_", " ", $ttitle);
    $displaytitle = $transfertitle;
    $ip = getenv("REMOTE_HOST");
    if (empty($ip)) {
       $ip = getenv("REMOTE_ADDR");
    }
    echo "<font class=\"pn-normal\">".pnVarPrepForStore($displaytitle)."</font>"
    ."<ul>"
    ."<li><font class=\"pn-sub\">"._RATENOTE1."</font>"
    ."<li><font class=\"pn-sub\">"._RATENOTE2."</font>"
    ."<li><font class=\"pn-sub\">"._RATENOTE3."</font>"
    ."<li><font class=\"pn-sub\">"._DRATENOTE4."</font>"
    ."<li><font class=\"pn-sub\">"._RATENOTE5."</font>";
    if (pnUserLoggedIn()) {
        $name = pnUserGetVar('uname');
        echo "<li><font class=\"pn-sub\">"._YOUAREREGGED."</font>"
        ."<li><font class=\"pn-sub\">"._FEELFREE2ADD."</font>";
    } else {
        echo "<li><font class=\"pn-sub\">"._YOUARENOTREGGED."</font>"
        ."<li><font class=\"pn-sub\">"._IFYOUWEREREG."</font>";
        $name = pnConfigGetVar('anonymous');
    }
    echo "</ul>"
    ."<form action=\"$modurl&amp;req=addrating\" method=\"post\">"
    ."<table border=\"0\" cellpadding=\"1\" cellspacing=\"0\" width=\"100%\">"
    ."<tr><td width=\"25\" nowrap></td>"
    ."<tr><td width=\"25\" nowrap></td><td width=\"550\">"
    ."<input type=\"hidden\" name=\"ratinglid\" value=\"$lid\">"
    ."<input type=\"hidden\" name=\"ratinguser\" value=\"$name\">"
    ."<input type=\"hidden\" name=\"ratinghost_name\" value=\"$ip\">"
    ."<font class=\"pn-normal\">"._RATETHISSITE.""
    ."<select name=\"rating\">"
    ."<option>--</option>"
    ."<option>10</option>"
    ."<option>9</option>"
    ."<option>8</option>"
    ."<option>7</option>"
    ."<option>6</option>"
    ."<option>5</option>"
    ."<option>4</option>"
    ."<option>3</option>"
    ."<option>2</option>"
    ."<option>1</option>"
    ."</select></font>"
    ."<font class=\"pn-sub\"><input type=\"submit\" value=\""._RATETHISSITE."\"></font>"
    ."<br><br>";
    if (pnUserLoggedIn()) {
        echo "<font class=\"pn-normal\">"._COMMENTS.":<br><textarea wrap=\"virtual\" cols=\"50\" rows=\"10\" name=\"ratingcomments\"></textarea>"
        ."<br><br><br>"
        ."</font></td>";
    } else {
        echo"<input type=\"hidden\" name=\"ratingcomments\" value=\"\">";
    }
    echo "</tr></table></form>";
    echo "<center>";

    downloadfooterchild($lid);

    echo "</center>";
    CloseTable();
    include 'footer.php';
}
?>