#!/bin/sh
#
# Startup for wcol daemon
#

# default settings.
wcol_program=/usr/local/wcol/wcol
wcol_kill_program=/usr/local/wcol/killwcol
wcol_conf=/usr/local/etc/wcol.conf
wcol_spooldir=/var/spool/wcol
wcol_pid=/var/run/wcol.pid

#
# If there is a global system configuration file, suck it in.
#
if [ -f /etc/defaults/rc.conf ]; then
	. /etc/defaults/rc.conf
	source_rc_confs
elif [ -f /etc/rc.conf ]; then
	. /etc/rc.conf
fi

case "$1" in
'start')
	if [ "x${wcol_enable}"  = "xYES" ] ; then
		if [ -f ${wcol_conf} -a -f ${wcol_program} ]; then
			if [ ! -d ${wcol_spooldir} ]; then
				/bin/mkdir ${wcol_spooldir}
			fi
			${wcol_program} >/dev/null 2>&1 &
			echo -n ' wcol'
		fi
	fi
	;;
'stop')
	if [ -f ${wcol_kill_program} ]; then
		${wcol_kill_program} >/dev/null 2>&1
	else 
		PID=`cat ${wcol_pid}`
		if [ ! -z "$PID" ] ;  then
			/bin/kill ${PID} >/dev/null 2>&1
		fi
		/bin/rm -f ${wcol_pid}
	fi
	;;
*)
	echo "Usage: wcol.sh { start | stop }"
	;;
esac

exit 0
