#! /bin/sh
#
# /sbin/init.d/web2ldap
#
# Author: Michael Stroeder <michael@stroeder.com>
# Start/stop script for web2ldap under S.u.S.E. linux
#
# Derived from
# /sbin/init.d/skeleton
# Copyright (c) 1995-1998 SuSE GmbH Nuernberg, Germany.
#

. /etc/rc.config

# Determine the base and follow a runlevel link name.
base=${0##*/}
link=${base#*[SK][0-9][0-9]}

# The echo return value for success (defined in /etc/rc.config).
return=$rc_done
case "$1" in

    start)
        echo -n "Starting web2ldap"
        # web2ldap is started in demon mode
        /usr/lib/web2ldap/sbin/web2ldap.py -u wwwrun -t off -d on &
        echo -e "$return"
        ;;

    stop)
        echo -n "Shutting down web2ldap"
        killproc -TERM /usr/lib/web2ldap/sbin/web2ldap.py || return=$rc_failed
        echo -e "$return"
        ;;

    restart)
        ## If first returns OK call the second, if first or
        ## second command fails, set echo return value.
        $0 stop  &&  $0 start  ||  return=$rc_failed
        ;;

esac

# Inform the caller not only verbosely and set an exit status.
test "$return" = "$rc_done" || exit 1
exit 0
