"""
msgzip.py
(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: msgzip.py,v 1.6 2002/01/09 02:00:32 michael Exp $
"""

try:

  import gzip

except ImportError:
  GzipFile=None

else:
  class GzipFile(gzip.GzipFile):
    """
    Stub class for gzip.GzipFile with delayed output of gzip-header
    """
    def __init__(self,filename=None,mode=None,compresslevel=9,fileobj=None):
      gzip.GzipFile.__init__(
        self,filename,mode,compresslevel,fileobj
      )
      self.compresslevel = compresslevel
      self._initialize = 1

    def write(self,data):
      if self._initialize:
        if self.mode == gzip.WRITE:
            self._write_gzip_header()
	self._initialize = 0
      gzip.GzipFile.write(self,data)

