#!/usr/local/bin/python2.0

########################################################################
# web2ldap -  web-based LDAP Client, see http://www.web2ldap.de
# (c) by Michael Stroeder <michael@stroeder.com>
########################################################################
# This software is distributed under the terms of the
# GPL (GNU GENERAL PUBLIC LICENSE) Version 2
# (see http://www.gnu.org/copyleft/gpl.html)
########################################################################

import sys,os,string

if os.environ.has_key('GATEWAY_INTERFACE'):

  if os.name == 'posix':
    # For finding web2ldapcnf.py in /etc/web2ldap on Unix systems
    sys.path.insert(0,'/usr/local/web2ldap/etc/web2ldap')
  else:
    # For finding web2ldapcnf.py in system dirs on Windows systems
    for i in ['SystemRoot','windir']:
      if os.environ.has_key(i):
	sys.path.insert(0,os.environ[i])

  exec_startdir = os.path.dirname(os.path.dirname(os.path.abspath(sys.argv[0])))
  sys.path.insert(0,string.join([exec_startdir,'etc','web2ldap'],os.sep))
  sys.path.insert(0,string.join([exec_startdir,'pylib'],os.sep))

  import web2ldapcnf
  for i in web2ldapcnf.pylibdirs:
    sys.path.insert(0,i)

  ########################################################################
  # Script was invoked trough CGI-BIN interface of web server
  ########################################################################

  import w2lhandler
  w2lhandler.HandleHTTPRequest(sys.stdin,sys.stdout,os.environ)
  sys.exit(0)

else:

  ######################################################################
  # The script was invoked directly => start persistent HTTP handler
  ######################################################################

  sys.stderr.write("""***Error:
This execuctable has to be run under the contol of a web server
through common gateway interface (CGI).

Use sbin/web2ldap.py instead for running web2ldap as stand-alone
web gateway demon.
""")
  sys.exit(1)
