########################################################################
# web2ldap
# (c) by Michael Stroeder <michael@stroeder.com>
# Distributed under GNU Public License (GPL)
# web-based LDAP Client, see http://www.web2ldap.de for details
########################################################################

import web2ldapcnf,cgissl,w2lcore,w2lgui,w2lcnf

##############################################################################
# Security info
##############################################################################

def w2l_SecInfo(outf,command,form,ls):


  w2lgui.PrintHeader(outf,'',form.accept_charset)
  w2lgui.MainMenuTable(outf,form,ls)

  outf.write("""
<div id=MessageDiv>
<h1>Security</h1>
<h2>LDAP</h2>
""")
  if ls.who:
    outf.write('<table><tr><td>Host</td><td><strong>%s</strong></td></tr><tr><td>Bind-DN</td><td><strong>%s</strong></td></tr></table>' % (ls.host,w2lcore.utf2display(form.accept_charset,ls.who)))
  else:
    outf.write('Your using anonymous access on <strong>%s</strong>.' % (ls.host))
  outf.write("""
<h2>HTTP Connection</h2>
<table>
  <tr><td>Your IP address:</td><td>%s</td></tr>
  <tr><td>Server signature:</td><td>%s</td></tr>
</table>
<h2>SSL Connection</h2>
""" % (form.env.get('REMOTE_ADDR','???'),form.env.get('SERVER_SIGNATURE','')))
  sec_valid_dn = w2lcnf.GetParam(ls,'sec_valid_dn','')
  sec_valid_idn = w2lcnf.GetParam(ls,'sec_valid_idn','')
  cgissl.PrintSecInfo(web2ldapcnf.sec_sslacceptedciphers,sec_valid_dn,sec_valid_idn,outf)
  outf.write('</DIV>')
  w2lgui.PrintFooter(outf)

