# Stub class for gzip.GzipFile with delayed output of gzip-header

try:

  import zlib,gzip

except ImportError:
  GzipFile=None

else:
  class GzipFile(gzip.GzipFile):

    def __init__(self,filename=None,mode=None,compresslevel=9,fileobj=None):
      if fileobj is None:
          fileobj = self.myfileobj = __builtin__.open(filename, mode or 'rb')
      if filename is None:
          if hasattr(fileobj, 'name'): filename = fileobj.name
          else: filename = ''
      if mode is None:
          if hasattr(fileobj, 'mode'): mode = fileobj.mode
          else: mode = 'rb'

      if mode[0:1] == 'r':
          self.mode = gzip.READ
          # Set flag indicating start of a new member
          self._new_member = 1 
          self.extrabuf = ""
          self.extrasize = 0
          self.filename = filename

      elif mode[0:1] == 'w' or mode[0:1] == 'a':
          self.mode = gzip.WRITE
          self._init_write(filename)
          self.compress = zlib.compressobj(compresslevel,
                                           zlib.DEFLATED, 
                                           -zlib.MAX_WBITS,
                                           zlib.DEF_MEM_LEVEL,
                                           0)
      else:
          raise ValueError, "Mode " + mode + " not supported"

      self.fileobj = fileobj

      self.__initialize__ = 1

    def write(self,data):
      if self.__initialize__:
        if self.mode == gzip.WRITE:
            self._write_gzip_header()
	self.__initialize__ = 0
      gzip.GzipFile.write(self,data)
