########################################################################
# web2ldap
# (c) by Michael Stroeder <michael@stroeder.com>
# Distributed under GNU Public License (GPL)
# web-based LDAP Client, see http://www.web2ldap.de for details
########################################################################

import sys,string,web2ldapcnf

# Modules shipped with web2ldap
import cgiforms,ldapbase,cgiforms,w2lcore,w2lgui,w2lcnf

##############################################################################
# Login form
##############################################################################

def w2l_Login(outf,command,form,ls):

  if 'login_binddn' in form.inputkeys:
    ls.who = form.field['login_binddn'][0].content
  if ls.dn!=None:
    dn_str = '<input type="hidden" name="dn" value="%s">' % (ls.dn.encode('utf-8'))
  else:
    dn_str = ''

  w2lgui.PrintHeader(outf,'Login',form.accept_charset)
  w2lgui.MainMenuTable(outf,form,ls)
  outf.write("""
<div id=inputdiv>
  <form 
    action="%s/bind"
    method="%s" 
    enctype="application/x-www-form-urlencoded"
    accept-charset="%s"
  >
    <h1>Login</h1>
    <p>
      Simply press <strong>Login</strong> for anonymous access.
    </p>
    %s
    %s
    <fieldset title="Host parameters">
      <table summary="Host parameters">
        <tr>
          <td>to host:port</td>
          <td><input type="hidden" name="host" value="%s">%s (%s)</td>
        </tr>
      </table>
    </fieldset>
    <p>
      <input type=submit value="Login">
    </p>
  </form>
</div>
""" % (
    form.script_name,
    web2ldapcnf.script_method,
    form.accept_charset,
    dn_str,
    w2lgui.BindInput % w2lcore.utf2display(form.accept_charset,ls.who),
    ls.host,
    ls.host,
    w2lcore.iso2display(
      form.accept_charset,
      web2ldapcnf.hosts.ldap_def.get(ls.host,{}).get('description','')
    ),
  )
)
  w2lgui.PrintFooter(outf)


def w2l_Relogin(outf,command,form,ls,e,reuse_binddn=0):
  if not reuse_binddn:
    ls.who = ''
  # Get the description of the LDAP exception
  ldap_exc_desc = e.args[0]['desc']
  # Pull out referral LDAP URL
  ldap_exc_info = e.args[0].get('info','')
#  searchroot_field = w2lgui.SearchRootField(form,ls,'search_root','Search Root')

  w2lgui.PrintHeader(outf,ldap_exc_desc,form.accept_charset)
  w2lgui.MainMenuTable(outf,form,ls)
  outf.write("""<h1>%s</h1>
<p>%s</p>
<div id=inputdiv>
  <form
    id=CommandForm
    action="%s/%s"
    method="%s"
    enctype="application/x-www-form-urlencoded"
    accept-charset="%s"
  >
    %s
    <fieldset title="Host parameters">
      <table summary="Host parameters">
        <tr>
          <td>to host:port</td>
          <td>%s (%s)</td>
        </tr>
      </table>
    </fieldset>
    <input type="submit" value="Retry">
"""  % (
      ldap_exc_desc,
      ldap_exc_info,
      form.script_name,
      command,
      web2ldapcnf.script_method,
      form.accept_charset,
      w2lgui.BindInput % (ls.who),
      ls.host,
      w2lcore.iso2display(
        form.accept_charset,
        web2ldapcnf.hosts.ldap_def.get(ls.host,{}).get('description','')
      ),
    )
  )
  form.hiddeninputparams(outf,['who','cred'])
  outf.write('</form>\n</div>')
  w2lgui.PrintFooter(outf)
