#!/bin/sh
# the next line restarts using wish \
exec wishstep8.0jp "$0" "$@"

wm withdraw .

set ttblibPath "/usr/X11R6/JDE/Binder"
set GLPath "~/GNUstep/Library/Binder"
set stageText #c0c0c0;set stageColor #c0c0c0
set LANG en

if {[file exists "~/GNUstep/Defaults/Binder"]} {
	source ~/GNUstep/Defaults/Binder
} else {
	source $ttblibPath/defaults/Binder
}

set binder_JBm $ttblibPath/modules
source $binder_JBm/appIconInfo.m
source $binder_JBm/readIcons.m
source $binder_JBm/process$LANG.m

binder_readIconSet

######################################
# process manipuration
#

proc binder_proclist_truncateList {pList} {

	set retList {}

	foreach i $pList {
		if {$i == {}} {
			continue
		}

		catch [set retList [concat $retList $i]]
	}

	return $retList
}

proc binder_killproc {} {
        set cursolPoint [.plisttop.plist curselection]
        if {$cursolPoint==""} return

	set procname [.plisttop.plist get $cursolPoint]
	set procID [.plisttop.plistHide get $cursolPoint]

	set ret [tk_dialog .killok "Kill process" \
		"Process $procname terminate?" {} 1 {OK} {Cancel}] 

	if {$ret == 0} {
		exec kill [expr $procID-1+1]
		binder_showproclist
		.plisttop.processName configure -text {}
	}
}

proc binder_showproclist {} {

	global ttblibPath procIcon

#	set scrollPoint [lindex [.plisttop.plist yview] 1]

	set procIcon CPUChip

	.plisttop.processName        configure -text {}
	.plisttop.plistbody3.pathStr configure -text {}
	.plisttop.plistbody3.statStr configure -text {}

	.plisttop.plist delete 0 end
	.plisttop.plistHide delete 0 end
	.plisttop.plistHide2 delete 0 end

	set templist [split [exec ps x] \n]

	for {set i 1} {$i<[llength $templist]} {incr i} {
		set templist2 [binder_proclist_truncateList [lindex $templist $i]]

		if {[string first ( [lindex $templist2 4]]} {
			.plisttop.plist insert end "   [lindex $templist2 4] [lindex $templist2 5]"
			.plisttop.plistHide insert end [lindex $templist2 0]
			.plisttop.plistHide2 insert end [lindex $templist2 2]
		}
	}

#	.plisttop.plist yview @0,$scrollPoint

#	after 1000 binder_showproclist
}

binder_proclist
wm protocol .plisttop WM_DELETE_WINDOW exit
