/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 /**
  *@author Murray Cumming
  */

#ifndef BAKERY_FILESELECTION_H
#define BAKERY_FILESELECTION_H

#include "../View/View.h"
#include <gnome--.h>
#include <libgnome/gnome-i18n.h>

#include <iostream>
#include <string>

namespace Bakery
{

//This FileSelection has a run() method, like Gnome::Dialog,
//which blocks and only returns when the user has responded
//to the dialog. Therefore you don't need to connect signal
//handlers to the OK and Cancel buttons. This makes code
//much simpler and clearer.

class FileSelection
 : public Gtk::FileSelection
{
public: 
	FileSelection(const Gtk::nstring&);
	virtual ~FileSelection();

	virtual bool run(); //returns false if nothing was selected.

protected:

  //Signal Handlers:
  virtual void on_Button_OK_clicked();
  virtual void on_Button_Cancel_clicked();
  virtual gint delete_event_impl(GdkEventAny *event); //override

  virtual void run_main_stop(); //called by signal handlers during run().

  //Member data:
  bool m_bRunInProgress;
  bool m_bRunSuccess; //Whether a file was selected.

};

} //namespace

#endif //BAKERY_FILESELECTION_H
