# Configure paths for bakery
# Modified by Murray Cumming from GtkExtra--.

dnl Test for BAKERY, and define BAKERY_CFLAGS and BAKERY_LIBS
dnl   to be used as follows:
dnl AM_PATH_BAKERY([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
AC_DEFUN(AM_PATH_BAKERY,
[dnl 
dnl Get the cflags and libraries from the bakery-config script
dnl
AC_ARG_WITH(BAKERY-prefix,[  --with-bakery-prefix=PREFIX
                          Prefix where bakery is installed (optional)],
            bakery_config_prefix="$withval", bakery_config_prefix="")
AC_ARG_WITH(bakery-exec-prefix,[  --with-bakery-exec-prefix=PREFIX
                          Exec prefix where bakery is installed (optional)],
            bakery_config_exec_prefix="$withval", bakery_config_exec_prefix="")
AC_ARG_ENABLE(bakerytest, [  --disable-bakerytest     Do not try to compile and run a test bakery program],
		    , enable_bakerytest=yes)

  if test x$bakery_config_exec_prefix != x ; then
     bakery_config_args="$bakery_config_args --exec-prefix=$bakery_config_exec_prefix"
     if test x${BAKERY_CONFIG+set} != xset ; then
        BAKERY_CONFIG=$bakery_config_exec_prefix/bin/bakery-config
     fi
  fi
  if test x$bakery_config_prefix != x ; then
     bakery_config_args="$bakery_config_args --prefix=$bakery_config_prefix"
     if test x${BAKERY_CONFIG+set} != xset ; then
        BAKERY_CONFIG=$bakery_config_prefix/bin/bakery-config
     fi
  fi

  AC_PATH_PROG(BAKERY_CONFIG, bakery-config, no)
  min_bakery_version=ifelse([$1], ,0.1.1,$1)

  AC_MSG_CHECKING(for bakery - version >= $min_bakery_version)
  no_bakery=""
  if test "$BAKERY_CONFIG" = "no" ; then
    no_bakery=yes
    AC_MSG_RESULT(no)
  else
    AC_MSG_RESULT(yes)
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS

    BAKERY_CFLAGS=`$BAKERY_CONFIG $bakery_config_args --cflags`
    BAKERY_LIBS=`$BAKERY_CONFIG $bakery_config_args --libs`
    bakery_config_major_version=`$BAKERY_CONFIG $bakery_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    bakery_config_minor_version=`$BAKERY_CONFIG $bakery_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    bakery_config_micro_version=`$BAKERY_CONFIG $bakery_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
  fi
  AC_SUBST(BAKERY_CFLAGS)
  AC_SUBST(BAKERY_LIBS)
])

