/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_THERMO_H
#define QWT_THERMO_H

#include "qwt_dimap.h"
#include "qwt_scldraw.h"
#include "qwt_sclif.h"
#include <qwidget.h>
#include <qcolor.h>
#include <qfont.h>
#include <qrect.h>


//! The Thermometer Widget
class QwtThermo
: public QWidget, public QwtScaleIf
{

	Q_OBJECT
	
 public:
	
	enum Orientation {Horizontal, Vertical};
	enum ScalePos {None, Left, Right, Top, Bottom};
	
 private:

	QwtDiMap d_map;
	QRect d_thermoRect;
	QColor d_fillColor;
	QColor d_alarmColor;
	
	Orientation d_orient;
	ScalePos d_scalePos;
	int d_horPad;
	int d_vertPad;
	int d_borderWidth;
	int d_scaleDist;
	int d_thermoWidth;

	double d_minValue;
	double d_maxValue;
	double d_value;
	double d_alarmLevel;
	int d_alarmEnabled;

	void init();
	
 public:

	QwtThermo(QWidget *parent = 0, const char *name = 0);
	~QwtThermo();

	void setOrientation(Orientation o, ScalePos s);
	void setBorderWidth(int w);
	void setFillColor(const QColor &c);
	void setAlarmColor(const QColor &c);
	void setAlarmLevel(double v);
	void setAlarmEnabled (int tf);
	void setPipeWidth(int w);
	void setRange(double vmin, double vmax);
	void setMargin(int m);
	double maxValue() { return d_maxValue; }
	double minValue() { return d_minValue; }
	double value() { return d_value; }
	
 protected:

	void paintEvent(QPaintEvent *e);
	void resizeEvent(QResizeEvent *e);
	void scaleChange();
 private:

	void drawThermo(QPainter *p);
	void fontChange(const QFont &oldFont);

public slots:
	void setValue(double val);
	
};

#endif




