/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_ARRBTN_H
#define QWT_ARRBTN_H

#include <qpushbutton.h>
#include "qwt_global.h"

/*!
  \brief Arrow Button

  A push button with one or more filled triangles on its front.
  An Arrow button can have 1 to 3 arrows in a row, pointing
  up, down, left or right.
*/
class QWT_EXPORT QwtArrowButton : public QPushButton
{
public:
    /*!
        Direction
        \sa QwtArrowButton::QwtArrowButton, QwtArrowButton::direction
    */
    enum Direction { Up, Down, Left, Right };

    QwtArrowButton (int num, Direction dir, QWidget *parent,
          const char *name = 0);

    Direction direction() const;
    int num() const;

    virtual QSize sizeHint() const;
    virtual QSize minimumSizeHint() const;
    virtual QSizePolicy sizePolicy() const;

protected:
    virtual void drawButtonLabel(QPainter *p);

private:
    int d_num;
    Direction d_dir;
};

#endif
