/**
 *
 * $Id: VkApp.h,v 1.4 1995/04/20 05:32:07 toshok Exp $
 * This file contains the class definition for the
 * VkApp Application Class.  This class must 
 * be instantiated exactly once in any given application.  
 * Results will be screwy if you don't follow this simple rule.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKAPP_H
#define VKAPP_H

#include <Xm/Xm.h>
#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#include <Vk/VkSimpleWindow.h>
#include <Vk/VkComponentList.h>
#include <Vk/VkCursorList.h>
#include <Vk/VkBusyDialog.h>

typedef enum {Animated, NotAnimated} VkCursorType;

class VkApp :public VkComponent {
friend VkSimpleWindow;
private:
    XtAppContext _theApp;
    Display *_theDisplay;
    char *_appClassName;
    VkSimpleWindow *_mainWindow;
    const char *_versionString;
    Cursor _currentCursor;
    Cursor _busyCursor;
    VkBusyDialog *_busyDialog;
    VkDialogManager *_aboutDialog;
    VkCursorType _cursorType;
    VkCursorList *_busyCursorList;
    char **_applicationArgv;
    int _applicationArgc;
    int _busyDepth;
    Boolean _startupIconified;
    Boolean _dumpResourceFile;
    int _argc;
    char **_argv;

    static String _defaultResources[];
    static XtResource _resourceList[];

protected:
    int parseCommandLine(XrmOptionDescRec *options,
			 Cardinal numOptions);

    VkComponentList _winList;

public:
    VkApp (char *appClassName,
	   int *argc,
	   char **argv,
	   XrmOptionDescRec *options = NULL,
	   int numOptions = 0);

    virtual void run();
    virtual void handleRawEvent(XEvent *event);
    virtual void handlePendingEvents();
    virtual void quitYourself();
    virtual void terminate(int status = 0);
  
    void setMainWindow(VkSimpleWindow *window);
    VkSimpleWindow *mainWindow() const;
  
    virtual void show();
    virtual void hide();
    virtual void iconify();
    virtual void open();
    virtual void raise();
    virtual void lower();

    void startupIconified(const Boolean flag);

    void setNormalCursor(Cursor c);
    virtual Cursor normalCursor();
    void setBusyCursor(Cursor c);
    void setBusyCursor(VkCursorList *animatedCursor);
    virtual Cursor busyCursor();

    void showCursor(Cursor c);
    virtual void busy(char *msg = NULL,
		      VkSimpleWindow *window = NULL);
  
    virtual void progressing(const char *msg = NULL);
  
    virtual void notBusy();
    void setBusyDialog(VkBusyDialog *dialog);

    void setVersionString(const char *versionInfo);
    const char *versionString();

    void setAboutDialog(VkDialogManager *dialog);
    VkDialogManager *aboutDialog() { return _aboutDialog;};

    // Application Data Access Functions

    char *name() const;
    char *applicationClassName() const;
    virtual const char *className();
    XtAppContext appContext() const;
    Display *display() const;
    char *shellGeometry() const;
    int argc() const;
    char **argv() const;
    char *argv(int index) const;
    Boolean startupIconified() const;
    Widget baseWidget();

    void registerWindow(VkSimpleWindow *win);
    void unregisterWindow(VkSimpleWindow *win);

    static const char *ViewKitReleaseString;
    static const int ViewKitMajorRelease;
    static const int ViewKitMinorRelease;
};

extern VkApp *theApplication;

#endif /* VKAPP_H */
