/**
 *
 * $Id: VkCombo.h,v 1.3 1995/04/20 05:36:26 toshok Exp $
 *
 * This file contains the definition of the VkCombo class,
 * which allows programmers to use the ComboBox widget,
 * generously donated to the world by Harald Albrecht.
 *
 * The interface for Vk purposes is much like the
 * OptionMenu, only without the static addition option.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKCOMBO_H
#define VKCOMBO_H

#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#ifdef USE_MOTIF20
#   ifdef OPEN_MOTIF
#include <Xm/ComboBoxP.h>
#include <Xm/TextF.h>
#   else
#include <Xm/ComboBox.h>
#   endif
#else
#include <Vk/ComboBox.h>
#endif

class VkCombo : public VkComponent {
private:
    static void _selectionCallback(Widget, XtPointer, XtPointer);

public:
    VkCombo (Widget parent, const char *name);

    int getIndex();
    void setIndex(int index);
    void selectIndex(int index);

    char *getValue();
    void setValue(char *value);
    void selectValue(char *value);
    
    void addItem(char *newitem);

    const char *className();

    static const char *const ItemSelectedCallback;
};

#endif // VKCOMBO_H
